/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FragmentReader {
    private int fragmentCount = 0;
    private long expectedLength;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public void addFragment(byte[] data) {
        try {
            if (this.out.size() == 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                this.expectedLength = byteBuffer.getInt(2) + 6;
            }
            this.out.write(data);
            ++this.fragmentCount;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() {
        this.out.reset();
    }

    public boolean isComplete() {
        return (long)this.out.size() == this.expectedLength;
    }

    public byte[] getCompleteMessage() {
        return this.out.toByteArray();
    }

    public boolean isFirstFragment() {
        return this.fragmentCount == 1;
    }
}

