/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.mail.MimeStandard;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultNHINDAgent_DecryptSignedContent_Test
extends TestCase {
    public void testCorrectMessageParamIsPassedToDecryptMessage() throws Exception {
        new TestPlan(){

            @Override
            protected MimeEntity decryptMessage_Internal(IncomingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
                return super.decryptMessage_Internal(message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.decryptMessageCalls);
            }
        }.perform();
    }

    public void testAllNonContentHeadersAreAddedBackToDecryptedMessage() throws Exception {
        new ContentTypeIsMultipartSignature(){

            @Override
            protected MimeEntity decryptMessage_Internal(IncomingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
                return super.decryptMessage_Internal(message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Enumeration allHeaders = this.theCreateMessage.getMessage().getAllHeaders();
                int i = 0;
                while (allHeaders.hasMoreElements()) {
                    allHeaders.nextElement();
                    ++i;
                }
                Assert.assertEquals((int)3, (int)i);
                Assert.assertEquals((int)1, (int)this.decryptMessageCalls);
            }
        }.perform();
    }

    public void testReturnValueFromDeserializeEnvelopedSignatureMethodIsSetAsMessageSignature() throws Exception {
        new ContentTypeIsEnvelopedSignature(){

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((Object)this.theDeserializeEnvelopedSignature, (Object)this.theCreateMessage.getSignature());
            }
        }.perform();
    }

    public void testReturnValueFromDeserializeSignatureEnvelopeMethodIsSetAsMessageSignature() throws Exception {
        new ContentTypeIsMultipartSignature(){

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((Object)this.theDeserializeSignatureEnvelope, (Object)this.theCreateMessage.getSignature());
            }
        }.perform();
    }

    public void testContentTypeIsNeitherMultipartSignedNorCmsEnvelopeMediaType_ThrowsAgentException() throws Exception {
        new TestPlan(){

            @Override
            protected String getContentType_Internal() throws MessagingException {
                this.theGetContentType = "application/pkcs7-mime;";
                return this.theGetContentType;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((this.getContentTypeCalls > 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agentException = (AgentException)exception;
                Assert.assertEquals((Object)AgentError.UnsignedMessage, (Object)agentException.getError());
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }
        }.perform();
    }

    public void testContentTypeIsInvalid_ThrowsMimeException() throws Exception {
        new TestPlan(){

            @Override
            protected String getContentType_Internal() throws MessagingException {
                this.theGetContentType = "theGetContentType";
                return this.theGetContentType;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((this.getContentTypeCalls > 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(exception instanceof MimeException));
                MimeException mimeException = (MimeException)exception;
                Assert.assertEquals((Object)MimeError.InvalidBody, (Object)mimeException.getError());
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }
        }.perform();
    }

    class ContentTypeIsMultipartSignature
    extends TestPlan {
        ContentTypeIsMultipartSignature() {
        }

        @Override
        protected String getContentType_Internal() throws MessagingException {
            this.theGetContentType = "multipart/signed;";
            return this.theGetContentType;
        }
    }

    class ContentTypeIsEnvelopedSignature
    extends TestPlan {
        ContentTypeIsEnvelopedSignature() {
        }

        @Override
        protected String getContentType_Internal() throws MessagingException {
            this.theGetContentType = "application/pkcs7-mime; smime-type=signed-data";
            return this.theGetContentType;
        }
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected MimeEntity theDecryptMessage;
        protected int decryptMessageCalls = 0;
        protected String theGetContentType;
        protected int getContentTypeCalls = 0;
        protected IncomingMessage theCreateMessage;
        protected Cryptographer theCreateCryptographer;
        protected int deserializeEnvelopedSignatureCalls = 0;
        protected CMSSignedData theDeserializeEnvelopedSignature;
        protected int deserializeSignatureEnvelopeCalls = 0;
        protected CMSSignedData theDeserializeSignatureEnvelope;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            impl.setCryptographer(this.createCryptographer());
            impl.decryptSignedContent(this.createMessage());
            this.doAssertions();
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected MimeEntity decryptMessage(IncomingMessage message) {
                    ++TestPlan.this.decryptMessageCalls;
                    return TestPlan.this.decryptMessage_Internal(message);
                }
            };
        }

        protected MimeEntity decryptMessage_Internal(IncomingMessage message) {
            try {
                MimeEntity entityToSig;
                String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
                MimeMessage entity = EntitySerializer.Default.deserialize(testMessage);
                Message message1 = new Message(entity){

                    public MimeEntity extractMimeEntity() {
                        MimeEntity retVal = null;
                        try {
                            InternetHeaders headers = new InternetHeaders();
                            if (this.headers.getAllHeaders().hasMoreElements()) {
                                Enumeration hEnum = this.headers.getAllHeaders();
                                while (hEnum.hasMoreElements()) {
                                    Header hdr = (Header)hEnum.nextElement();
                                    if (!MimeStandard.startsWith((String)hdr.getName(), (String)"Content-")) continue;
                                    headers.addHeader(hdr.getName(), hdr.getValue());
                                }
                                if (!headers.getAllHeaders().hasMoreElements()) {
                                    throw new MimeException(MimeError.InvalidMimeEntity);
                                }
                                retVal = new MimeEntity(headers, this.getContentAsBytes()){

                                    public String getContentType() throws MessagingException {
                                        ++TestPlan.this.getContentTypeCalls;
                                        return TestPlan.this.getContentType_Internal();
                                    }
                                };
                            }
                        }
                        catch (MessagingException e) {
                            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
                        }
                        return retVal;
                    }
                };
                this.theDecryptMessage = entityToSig = message1.extractEntityForSignature(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            return this.theDecryptMessage;
        }

        protected String getContentType_Internal() throws MessagingException {
            this.theGetContentType = "application/pkcs7-mime; smime-type=signed-data";
            return this.theGetContentType;
        }

        protected IncomingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            msg.addHeader("Subject", "subject");
            msg.addHeader("Bcc", "bcc");
            msg.addHeader("Content-ID", "content-id");
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new IncomingMessage(msg, recipients, sender);
            return this.theCreateMessage;
        }

        protected CMSSignedData deserializeEnvelopedSignature_Internal(MimeEntity envelopeEntity) throws Exception {
            CMSSignedData signedData;
            this.theDeserializeEnvelopedSignature = signedData = this.createCMSSignedData();
            return this.theDeserializeEnvelopedSignature;
        }

        protected CMSSignedData deserializeSignatureEnvelope_Internal(SignedEntity entity) throws Exception {
            CMSSignedData signedData;
            this.theDeserializeSignatureEnvelope = signedData = this.createCMSSignedData();
            return this.theDeserializeSignatureEnvelope;
        }

        protected CMSSignedData createCMSSignedData() throws Exception {
            String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
            MimeMessage entity1 = EntitySerializer.Default.deserialize(testMessage);
            Message message = new Message(entity1);
            MimeEntity entityToSig = message.extractEntityForSignature(true);
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entityToSig);
            MimeBodyPart partToSign = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            SMIMESignedGenerator gen = new SMIMESignedGenerator();
            MimeMultipart retVal = gen.generate(partToSign, "BC");
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            retVal.writeTo((OutputStream)oStream);
            oStream.flush();
            byte[] serialzedBytes = oStream.toByteArray();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(serialzedBytes, retVal.getContentType());
            MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
            CMSSignedData signeddata = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPartInbound((BodyPart)partToSign), verifyMM.getBodyPart(1).getInputStream());
            return signeddata;
        }

        protected Cryptographer createCryptographer() {
            this.theCreateCryptographer = new SMIMECryptographerImpl(){

                public CMSSignedData deserializeEnvelopedSignature(MimeEntity envelopeEntity) {
                    ++TestPlan.this.deserializeEnvelopedSignatureCalls;
                    try {
                        return TestPlan.this.deserializeEnvelopedSignature_Internal(envelopeEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail();
                        return null;
                    }
                }

                public CMSSignedData deserializeSignatureEnvelope(SignedEntity entity) {
                    ++TestPlan.this.deserializeSignatureEnvelopeCalls;
                    try {
                        return TestPlan.this.deserializeSignatureEnvelope_Internal(entity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail();
                        return null;
                    }
                }
            };
            return this.theCreateCryptographer;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

