/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.UniformCertificateStore;
import org.nhindirect.stagent.trust.TrustChainValidator;

public class TrustChainValidator_IntermidiateCert_Test
extends TestCase {
    protected byte[] getCertificateFileData(String file) throws Exception {
        File fl = new File("src/test/resources/certs/" + file);
        return FileUtils.readFileToByteArray((File)fl);
    }

    private X509Certificate certFromData(byte[] data) {
        X509Certificate retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    retVal = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)((PrivateKey)key)) : cert;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new NHINDException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return retVal;
    }

    public void testValidateCertAgainstNonRootCA_CertGenToolCerts() throws Exception {
        X509Certificate anchor = this.certFromData(this.getCertificateFileData("messaging.cerner.com.der"));
        X509Certificate certToValidate = this.certFromData(this.getCertificateFileData("greg@messaging.cerner.com.p12"));
        TrustChainValidator validator = new TrustChainValidator();
        boolean isTrusted = false;
        try {
            isTrusted = validator.isTrusted(certToValidate, Arrays.asList(anchor));
        }
        catch (Exception e) {
            // empty catch block
        }
        TrustChainValidator_IntermidiateCert_Test.assertTrue((boolean)isTrusted);
    }

    public void testValidateCertAgainstNonRootCA_OpenSSLCerts() throws Exception {
        X509Certificate anchor = this.certFromData(this.getCertificateFileData("cert-b.der"));
        X509Certificate certToValidate = this.certFromData(this.getCertificateFileData("cert-a.der"));
        TrustChainValidator validator = new TrustChainValidator();
        boolean isTrusted = false;
        try {
            isTrusted = validator.isTrusted(certToValidate, Arrays.asList(anchor));
        }
        catch (Exception e) {
            // empty catch block
        }
        TrustChainValidator_IntermidiateCert_Test.assertTrue((boolean)isTrusted);
    }

    public void testValidateCertAgainstNonRootCA_CAInPublicResolver_OpenSSLCerts() throws Exception {
        X509Certificate anchor = this.certFromData(this.getCertificateFileData("cert-b.der"));
        X509Certificate certToValidate = this.certFromData(this.getCertificateFileData("cert-a.der"));
        UniformCertificateStore publicResolver = new UniformCertificateStore(anchor);
        TrustChainValidator validator = new TrustChainValidator();
        validator.setCertificateResolver(Arrays.asList(publicResolver));
        boolean isTrusted = false;
        try {
            isTrusted = validator.isTrusted(certToValidate, Arrays.asList(anchor));
        }
        catch (Exception e) {
            // empty catch block
        }
        TrustChainValidator_IntermidiateCert_Test.assertTrue((boolean)isTrusted);
    }

    public void testValidateCertMissingIntermediateCert_OpenSSLCerts() throws Exception {
        X509Certificate anchor = this.certFromData(this.getCertificateFileData("cert-c.der"));
        X509Certificate certToValidate = this.certFromData(this.getCertificateFileData("cert-a.der"));
        TrustChainValidator validator = new TrustChainValidator();
        boolean isTrusted = false;
        try {
            isTrusted = validator.isTrusted(certToValidate, Arrays.asList(anchor));
        }
        catch (Exception e) {
            // empty catch block
        }
        TrustChainValidator_IntermidiateCert_Test.assertFalse((boolean)isTrusted);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

