/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.nhindirect.stagent.cert.SignerCertPair;
import org.nhindirect.stagent.cert.Thumbprint;

public class CryptoExtensions {
    private static CertificateFactory certFactory;

    public static boolean isEqualThumbprint(X509Certificate cert1, X509Certificate cert2) {
        return Thumbprint.toThumbprint(cert1).equals(Thumbprint.toThumbprint(cert2));
    }

    public static boolean certSubjectContainsName(X509Certificate cert, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        return cert.getSubjectDN().getName().contains(name);
    }

    public static boolean matchName(X509Certificate cert, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        String distinguishedName = "CN=" + name;
        return cert.getSubjectDN().getName().contains(distinguishedName);
    }

    public static Collection<SignerCertPair> findSignersByName(CMSSignedData signedData, String name, Collection<String> excludeNames) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<SignerCertPair> retVal = null;
        try {
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                X509Certificate cert;
                Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
                if (certCollection == null || certCollection.size() <= 0 || !CryptoExtensions.certSubjectContainsName(cert = (X509Certificate)certCollection.iterator().next(), name)) continue;
                boolean exclude = false;
                if (excludeNames != null) {
                    for (String excludeStr : excludeNames) {
                        if (!CryptoExtensions.certSubjectContainsName(cert, excludeStr)) continue;
                        exclude = true;
                        break;
                    }
                }
                if (exclude) continue;
                if (retVal == null) {
                    retVal = new ArrayList<SignerCertPair>();
                }
                retVal.add(new SignerCertPair(signer, CryptoExtensions.convertToProfileProvidedCertImpl(cert)));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return retVal == null ? Collections.emptyList() : retVal;
    }

    public static X509Certificate findCertByName(Collection<X509Certificate> certs, String name) {
        for (X509Certificate cert : certs) {
            if (!CryptoExtensions.certSubjectContainsName(cert, name)) continue;
            return cert;
        }
        return null;
    }

    public static SignerCertPair findSignerByCert(CMSSignedData signedData, X509Certificate searchCert) {
        if (searchCert == null) {
            throw new IllegalArgumentException();
        }
        try {
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                SignerId signerId = signer.getSID();
                if (!signerId.getIssuer().equals(searchCert.getIssuerX500Principal()) || !signerId.getSerialNumber().equals(searchCert.getSerialNumber())) continue;
                return new SignerCertPair(signer, searchCert);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static X509Certificate convertToProfileProvidedCertImpl(X509Certificate certToConvert) {
        X509Certificate retVal = null;
        try {
            BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(certToConvert.getEncoded()));
            retVal = (X509Certificate)certFactory.generateCertificate(stream);
            ((InputStream)stream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    static {
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

