/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.util.ArrayList;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimePart;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;

public class DefaultMessageEnvelope
implements MessageEnvelope {
    protected NHINDAgent agent;
    protected Message message;
    protected NHINDAddress sender;
    protected NHINDAddressCollection to;
    protected NHINDAddressCollection cc;
    protected NHINDAddressCollection bcc;
    protected NHINDAddressCollection recipients;
    protected NHINDAddressCollection rejectedRecipients;
    protected NHINDAddressCollection domainRecipients;
    protected Collection<NHINDAddress> otherRecipients;

    public DefaultMessageEnvelope(Message message) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        this.message = message;
        this.setRecipients(this.collectRecipients());
        try {
            if (message.getFrom() == null || message.getFrom().length == 0) {
                throw new AgentException(AgentError.MissingFrom);
            }
            this.setSender(new NHINDAddress((InternetAddress)message.getFrom()[0], AddressSource.From));
        }
        catch (MessagingException e) {
            throw new AgentException(AgentError.MissingFrom, (Exception)((Object)e));
        }
    }

    public DefaultMessageEnvelope(String rawMessage) {
        this(DefaultMessageEnvelope.fromStringToMessage(rawMessage));
    }

    public DefaultMessageEnvelope(Message message, NHINDAddressCollection recipients, NHINDAddress sender) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        this.message = message;
        this.setRecipients(recipients);
        this.setSender(sender);
    }

    public DefaultMessageEnvelope(String rawMessage, NHINDAddressCollection recipients, NHINDAddress sender) {
        this(DefaultMessageEnvelope.fromStringToMessage(rawMessage), recipients, sender);
    }

    protected DefaultMessageEnvelope(MessageEnvelope envelope) {
        this.agent = envelope.getAgent();
        this.message = envelope.getMessage();
        this.recipients = envelope.getRecipients();
        this.sender = envelope.getSender();
    }

    private static Message fromStringToMessage(String rawMessage) {
        try {
            return new Message(EntitySerializer.Default.deserialize(rawMessage));
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    @Override
    public NHINDAgent getAgent() {
        return this.agent;
    }

    public void setAgent(NHINDAgent agent) {
        this.agent = agent;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    protected void setMessage(Message message) {
        if (message == null) {
            throw new AgentException(AgentError.MissingMessage);
        }
        this.message = message;
    }

    @Override
    public NHINDAddress getSender() {
        return this.sender;
    }

    protected void setSender(NHINDAddress sender) {
        if (sender == null) {
            throw new AgentException(AgentError.NoSender);
        }
        this.sender = sender;
    }

    @Override
    public NHINDAddressCollection getRecipients() {
        if (this.recipients == null) {
            this.collectRecipients();
        }
        return this.recipients;
    }

    protected void setRecipients(NHINDAddressCollection recipients) {
        if (recipients == null || recipients.size() == 0) {
            throw new AgentException(AgentError.NoRecipients);
        }
        this.recipients = recipients;
    }

    @Override
    public boolean hasRecipients() {
        return this.recipients != null && this.recipients.size() > 0;
    }

    @Override
    public NHINDAddressCollection getRejectedRecipients() {
        if (this.rejectedRecipients == null) {
            this.rejectedRecipients = new NHINDAddressCollection();
        }
        return this.rejectedRecipients;
    }

    @Override
    public boolean hasRejectedRecipients() {
        NHINDAddressCollection rejRecipients = this.getRejectedRecipients();
        return rejRecipients != null && rejRecipients.size() > 0;
    }

    @Override
    public NHINDAddressCollection getDomainRecipients() {
        if (this.domainRecipients == null) {
            this.categorizeRecipients(this.getAgent().getDomains());
        }
        return this.domainRecipients;
    }

    @Override
    public boolean hasDomainRecipients() {
        NHINDAddressCollection dRecipients = this.getDomainRecipients();
        return dRecipients != null && dRecipients.size() > 0;
    }

    @Override
    public Collection<NHINDAddress> getOtherRecipients() {
        if (this.otherRecipients == null) {
            this.categorizeRecipients(this.getAgent().getDomains());
        }
        return this.otherRecipients;
    }

    @Override
    public boolean hasOtherRecipients() {
        Collection<NHINDAddress> oRecipients = this.getOtherRecipients();
        return oRecipients != null && oRecipients.size() > 0;
    }

    protected NHINDAddressCollection getTo() {
        if (this.to == null) {
            this.to = NHINDAddressCollection.parse(this.message.getToHeader(), AddressSource.To);
        }
        return this.to;
    }

    protected NHINDAddressCollection getCC() {
        if (this.cc == null) {
            this.cc = NHINDAddressCollection.parse(this.message.getCCHeader(), AddressSource.CC);
        }
        return this.cc;
    }

    protected NHINDAddressCollection getBCC() {
        if (this.bcc == null) {
            this.bcc = NHINDAddressCollection.parse(this.message.getBCCHeader(), AddressSource.BCC);
        }
        return this.bcc;
    }

    @Override
    public String serializeMessage() {
        return EntitySerializer.Default.serialize((MimePart)this.getMessage());
    }

    protected void clear() {
        this.message = null;
        this.sender = null;
        this.to = null;
        this.cc = null;
        this.bcc = null;
        this.recipients = null;
        this.rejectedRecipients = null;
        this.domainRecipients = null;
        this.otherRecipients = null;
    }

    protected NHINDAddressCollection collectRecipients() {
        NHINDAddressCollection addresses = new NHINDAddressCollection();
        if (this.getTo() != null) {
            addresses.addAll(this.getTo());
        }
        if (this.getCC() != null) {
            addresses.addAll(this.getCC());
        }
        if (this.getBCC() != null) {
            addresses.addAll(this.getBCC());
        }
        return addresses;
    }

    protected void updateRoutingHeaders(NHINDAddressCollection rejectedRecipients) {
        if (rejectedRecipients == null || rejectedRecipients.size() == 0) {
            return;
        }
        try {
            if (this.getTo() != null) {
                this.getTo().removeAll(rejectedRecipients);
                if (this.getTo().isEmpty()) {
                    this.getMessage().removeHeader("to");
                } else {
                    this.getMessage().setHeader("to", this.getTo().toString());
                }
            }
            if (this.getCC() != null) {
                this.getCC().removeAll(rejectedRecipients);
                if (this.getCC().isEmpty()) {
                    this.getMessage().removeHeader("cc");
                } else {
                    this.getMessage().setHeader("cc", this.getCC().toString());
                }
            }
            if (this.getBCC() != null) {
                this.getBCC().removeAll(rejectedRecipients);
                if (this.getBCC().isEmpty()) {
                    this.getMessage().removeHeader("bcc");
                } else {
                    this.getMessage().setHeader("bcc", this.getBCC().toString());
                }
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidHeader);
        }
    }

    protected void updateRoutingHeaders() {
        if (this.hasRejectedRecipients()) {
            this.updateRoutingHeaders(this.getRejectedRecipients());
        }
    }

    protected void validate() {
    }

    @Override
    public void ensureRecipientsCategorizedByDomain(Collection<String> domains) {
        if (this.hasDomainRecipients() || this.hasOtherRecipients()) {
            return;
        }
        this.categorizeRecipients(domains);
    }

    protected void categorizeRecipients(Collection<String> domains) {
        if (domains == null || domains.size() == 0) {
            throw new IllegalArgumentException();
        }
        NHINDAddressCollection recipients = this.getRecipients();
        this.domainRecipients = new NHINDAddressCollection();
        this.otherRecipients = new ArrayList<NHINDAddress>();
        for (NHINDAddress address : recipients) {
            if (address.isInDomain(domains)) {
                this.domainRecipients.add(address);
                continue;
            }
            this.otherRecipients.add(address);
        }
    }

    protected void categorizeRecipients(TrustEnforcementStatus minTrustStatus) {
        this.rejectedRecipients = NHINDAddressCollection.create(this.getRecipients().getUntrusted(minTrustStatus));
        this.getRecipients().removeUntrusted(minTrustStatus);
    }
}

