/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;

public class NHINDAddress
extends InternetAddress {
    static final long serialVersionUID = -5804460458173783482L;
    private AddressSource source;
    private Collection<X509Certificate> certificates;
    private TrustEnforcementStatus m_trustStatus;
    private Collection<X509Certificate> m_trustAnchors;

    public NHINDAddress(String address) {
        this(address, AddressSource.Unknown);
    }

    public NHINDAddress(InternetAddress address) {
        this(address, AddressSource.Unknown);
    }

    public NHINDAddress(String address, AddressSource source) {
        this.source = source;
        this.setAddress(address);
    }

    public NHINDAddress(InternetAddress address, AddressSource source) {
        this.source = source;
        this.setAddress(address.getAddress());
    }

    public NHINDAddress(String address, Collection<X509Certificate> certificates) {
        this.setAddress(address);
        this.certificates = certificates;
    }

    public String getHost() {
        String retVal = "";
        String address = this.getAddress();
        int index = address.indexOf(60);
        if (index > -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(62)) > -1) {
            address = address.substring(0, index);
        }
        if ((index = address.indexOf("@")) >= 0) {
            retVal = address.substring(index + 1);
        }
        return retVal;
    }

    public Collection<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Collection<X509Certificate> certs) {
        this.certificates = certs;
    }

    public boolean hasCertificates() {
        return this.certificates != null && this.certificates.size() > 0;
    }

    public Collection<X509Certificate> getTrustAnchors() {
        return Collections.unmodifiableCollection(this.m_trustAnchors);
    }

    public void setTrustAnchors(Collection<X509Certificate> certs) {
        this.m_trustAnchors = certs;
    }

    public boolean hasTrustAnchors() {
        return this.m_trustAnchors != null && this.m_trustAnchors.size() > 0;
    }

    public TrustEnforcementStatus getStatus() {
        return this.m_trustStatus;
    }

    public void setStatus(TrustEnforcementStatus value) {
        this.m_trustStatus = value;
    }

    public boolean isTrusted(TrustEnforcementStatus minTrustStatus) {
        return this.m_trustStatus.compareTo(minTrustStatus) >= 0;
    }

    public AddressSource getSource() {
        return this.source;
    }

    public void setSource(AddressSource source) {
        this.source = source;
    }

    public boolean domainEquals(String domain) {
        return this.getHost().equalsIgnoreCase(domain);
    }

    public boolean isInDomain(Collection<String> domains) {
        for (String domain : domains) {
            if (!this.domainEquals(domain)) continue;
            return true;
        }
        return false;
    }

    public static String getHost(InternetAddress theAddress) {
        String retVal = "";
        String address = theAddress.getAddress();
        int index = address.indexOf(60);
        if (index > -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(62)) > -1) {
            address = address.substring(0, index);
        }
        if ((index = address.indexOf("@")) >= 0) {
            retVal = address.substring(index + 1);
        }
        return retVal;
    }
}

