/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.security.auth.x500.X500Principal;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.Thumbprint;

public class TrustChainValidator {
    private static int DefaultMaxIssuerChainLength = 5;
    private Collection<CertificateResolver> certResolvers;
    private int maxIssuerChainLength = DefaultMaxIssuerChainLength;

    public boolean isCertificateResolver() {
        return this.certResolvers != null;
    }

    public Collection<CertificateResolver> getCertificateResolver() {
        return this.certResolvers;
    }

    public void setCertificateResolver(Collection<CertificateResolver> resolver) {
        this.certResolvers = resolver;
    }

    public boolean isTrusted(X509Certificate certificate, Collection<X509Certificate> anchors) {
        if (certificate == null) {
            throw new IllegalArgumentException();
        }
        if (anchors == null || anchors.size() == 0) {
            return false;
        }
        try {
            Collection<X509Certificate> intermediatesCerts;
            CertPath certPath = null;
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.add(certificate);
            if (this.certResolvers != null && (intermediatesCerts = this.resolveIntermediateIssuers(certificate, anchors)) != null && intermediatesCerts.size() > 0) {
                certs.addAll(intermediatesCerts);
            }
            HashSet<TrustAnchor> trustAnchorSet = new HashSet<TrustAnchor>();
            for (X509Certificate archor : anchors) {
                trustAnchorSet.add(new TrustAnchor(archor, null));
            }
            PKIXParameters params = new PKIXParameters(trustAnchorSet);
            params.setRevocationEnabled(false);
            certPath = factory.generateCertPath(certs);
            CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX", "BC");
            pathValidator.validate(certPath, params);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Collection<X509Certificate> resolveIntermediateIssuers(X509Certificate certificate, Collection<X509Certificate> anchors) {
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        this.resolveIntermediateIssuers(certificate, issuers, anchors);
        return issuers;
    }

    private void resolveIntermediateIssuers(X509Certificate certificate, Collection<X509Certificate> issuers, Collection<X509Certificate> anchors) {
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        if (issuers == null) {
            throw new IllegalArgumentException("Issuers collection cannot be null.");
        }
        this.resolveIssuers(certificate, issuers, 0, anchors);
    }

    private boolean isIssuerInCollection(Collection<X509Certificate> issuers, X509Certificate checkIssuer) {
        for (X509Certificate issuer : issuers) {
            if (!checkIssuer.getSubjectX500Principal().equals(issuer.getSubjectX500Principal()) || !Thumbprint.toThumbprint(issuer).equals(Thumbprint.toThumbprint(checkIssuer))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuerInAnchors(Collection<X509Certificate> anchors, X509Certificate checkIssuer) {
        for (X509Certificate anchor : anchors) {
            if (!Thumbprint.toThumbprint(anchor).equals(Thumbprint.toThumbprint(checkIssuer))) continue;
            return true;
        }
        return false;
    }

    private void resolveIssuers(X509Certificate certificate, Collection<X509Certificate> issuers, int chainLength, Collection<X509Certificate> anchors) {
        X500Principal issuerPrin = certificate.getIssuerX500Principal();
        if (issuerPrin.equals(certificate.getSubjectX500Principal())) {
            return;
        }
        for (X509Certificate issuer : issuers) {
            if (!issuerPrin.equals(issuer.getSubjectX500Principal())) continue;
            return;
        }
        if (chainLength >= this.maxIssuerChainLength) {
            return;
        }
        String address = this.getIssuerAddress(issuerPrin);
        if (address == null || address.isEmpty()) {
            return;
        }
        ArrayList<X509Certificate> issuerCerts = new ArrayList<X509Certificate>();
        for (CertificateResolver publicResolver : this.certResolvers) {
            try {
                Collection<X509Certificate> holdCerts = publicResolver.getCertificates(new InternetAddress(address));
                if (holdCerts == null || holdCerts.size() <= 0) continue;
                issuerCerts.addAll(holdCerts);
            }
            catch (AddressException e) {}
        }
        if (issuerCerts.size() == 0) {
            return;
        }
        for (X509Certificate issuerCert : issuerCerts) {
            if (!issuerCert.getSubjectX500Principal().equals(issuerPrin) || this.isIssuerInCollection(issuers, issuerCert) || this.isIssuerInAnchors(anchors, issuerCert)) continue;
            issuers.add(issuerCert);
            this.resolveIssuers(issuerCert, issuers, chainLength + 1, anchors);
        }
    }

    private String getIssuerAddress(X500Principal issuerPrin) {
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = issuerPrin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        String address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }
}

