/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultMessageSignatureImpl_CheckThumbprint_Test
extends TestCase {
    public void testMessageSenderDoesNotHaveCertificates_ReturnsFalse() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = false;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assert.assertFalse((boolean)checkThumbprint);
            }
        }.perform();
    }

    public void testThumbprintMatches_ReturnsTrue() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = true;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assert.assertTrue((boolean)checkThumbprint);
            }
        }.perform();
    }

    public void testThumbprintDoesNotMatch_ReturnsFalse() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = true;
                return this.theHasCertificates;
            }

            @Override
            protected DefaultMessageSignatureImpl createMessageSignature() throws Exception {
                return new DefaultMessageSignatureImpl(this.createSignerInformation(), false, (X509Certificate)TestUtils.getInternalCert("bob")){};
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assert.assertFalse((boolean)checkThumbprint);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected NHINDAddress theCreateMessageSender;
        protected Collection<X509Certificate> theGetCertificates;
        protected int getCertificatesCalls = 0;
        protected boolean theHasCertificates;
        protected int hasCertificatesCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultMessageSignatureImpl impl = this.createMessageSignature();
            boolean checkThumbprint = impl.checkThumbprint(this.createMessageSender());
            this.doAssertions(checkThumbprint);
        }

        protected DefaultMessageSignatureImpl createMessageSignature() throws Exception {
            return new DefaultMessageSignatureImpl(this.createSignerInformation(), false, this.theGetCertificates.iterator().next()){};
        }

        protected NHINDAddress createMessageSender() throws Exception {
            this.theCreateMessageSender = new NHINDAddress(""){

                public boolean hasCertificates() {
                    ++TestPlan.this.hasCertificatesCalls;
                    return TestPlan.this.hasCertificates_Internal();
                }

                public Collection<X509Certificate> getCertificates() {
                    ++TestPlan.this.getCertificatesCalls;
                    return TestPlan.this.getCertificates_Internal();
                }
            };
            return this.theCreateMessageSender;
        }

        protected Collection<X509Certificate> getCertificates_Internal() {
            return this.theGetCertificates;
        }

        protected boolean hasCertificates_Internal() {
            this.theHasCertificates = false;
            return this.theHasCertificates;
        }

        protected SignerInformation createSignerInformation() throws Exception {
            X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
            String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
            MimeMessage entity = EntitySerializer.Default.deserialize(testMessage);
            Message message = new Message(entity);
            MimeEntity entityToSig = message.extractEntityForSignature(true);
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entityToSig);
            MimeBodyPart partToSign = null;
            try {
                partToSign = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            }
            catch (Exception e) {
                // empty catch block
            }
            SMIMESignedGenerator gen = new SMIMESignedGenerator();
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.dES_EDE3_CBC);
            caps.addCapability(SMIMECapability.rC2_CBC, 128);
            caps.addCapability(SMIMECapability.dES_CBC);
            caps.addCapability(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            caps.addCapability(PKCSObjectIdentifiers.x509Certificate);
            signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            gen.addSigner(internalCert.getPrivateKey(), (X509Certificate)internalCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable((DEREncodableVector)signedAttrs), null);
            certList.add((X509Certificate)internalCert);
            this.theGetCertificates = certList;
            MimeMultipart retVal = null;
            CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(certsAndcrls);
            retVal = gen.generate(partToSign, "BC");
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            retVal.writeTo((OutputStream)oStream);
            oStream.flush();
            byte[] serialzedBytes = oStream.toByteArray();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(serialzedBytes, retVal.getContentType());
            MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
            CMSSignedData signeddata = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPartInbound((BodyPart)partToSign), verifyMM.getBodyPart(1).getInputStream());
            SignerInformationStore signers = signeddata.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            if (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                return signer;
            }
            return null;
        }

        protected void doAssertions(boolean checkThumbprint) throws Exception {
        }
    }
}

