/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultMessageEnvelope;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessIncoming_AsMessageEnvelope_Test
extends TestCase {
    public void testMessageEnvelopeIsNull_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected MessageEnvelope createEnvelope() throws Exception {
                this.theCreateEnvelope = null;
                return this.theCreateEnvelope;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateEnvelope);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testCorrectMessageEnvelopeIsPassedToCheckEnvelopeAddressesMethod() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(MessageEnvelope envelope) {
                Assert.assertEquals((Object)this.theCreateEnvelope, (Object)envelope);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    public void testMessageEnvelopeIsNotNull_ProcessIncomingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.processIncomingCalls);
                Assert.assertNotNull((Object)this.theProcessIncoming);
                Assert.assertEquals((Object)this.theProcessIncoming, (Object)processIncoming);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected IncomingMessage theProcessIncoming;
        protected int processIncomingCalls = 0;
        protected int checkEnvelopeAddressesCalls = 0;
        protected MessageEnvelope theCreateEnvelope;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            IncomingMessage processIncoming = impl.processIncoming(this.createEnvelope());
            this.doAssertions(processIncoming);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void checkEnvelopeAddresses(MessageEnvelope envelope) {
                    ++TestPlan.this.checkEnvelopeAddressesCalls;
                    TestPlan.this.checkEnvelopeAddresses_Internal(envelope);
                }

                public IncomingMessage processIncoming(IncomingMessage message) {
                    ++TestPlan.this.processIncomingCalls;
                    return TestPlan.this.processIncoming_Internal(message);
                }
            };
        }

        protected IncomingMessage processIncoming_Internal(IncomingMessage message) {
            this.theProcessIncoming = message;
            return this.theProcessIncoming;
        }

        protected void checkEnvelopeAddresses_Internal(MessageEnvelope envelope) {
        }

        protected MessageEnvelope createEnvelope() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateEnvelope = new DefaultMessageEnvelope(msg, recipients, sender);
            return this.theCreateEnvelope;
        }

        protected void doAssertions(IncomingMessage processIncoming) throws Exception {
        }
    }
}

