/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.util.Strings;
import org.bouncycastle.x509.X509Store;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.TestUtils;

public class SigTest
extends TestCase {
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private static final String CERTIFICATE_MANAGEMENT_CONTENT = "application/pkcs7-mime; name=smime.p7c; smime-type=certs-only";
    private static final String DETACHED_SIGNATURE_TYPE = "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data";
    private static final String ENCAPSULATED_SIGNED_CONTENT_TYPE = "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data";
    protected boolean useBase64 = true;
    protected String encoding = "base64";
    private List _certStores = new ArrayList();
    private List _signers = new ArrayList();
    private List _oldSigners = new ArrayList();
    private List _attributeCerts = new ArrayList();
    private Map _digests = new HashMap();
    private final String _defaultContentTransferEncoding = "7bit";

    public void testCreateVerifySig() throws Exception {
        X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
        X509Certificate caCert = TestUtils.getExternalCert("cacert");
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeMessage entity = EntitySerializer.Default.deserialize(testMessage);
        Message message = new Message(entity);
        MimeEntity entityToSig = message.extractEntityForSignature(true);
        byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entityToSig);
        MimeBodyPart partToSign = null;
        try {
            partToSign = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
        }
        catch (Exception e) {
            // empty catch block
        }
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        caps.addCapability(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
        caps.addCapability(PKCSObjectIdentifiers.x509Certificate);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        ArrayList<X509CertificateEx> certList = new ArrayList<X509CertificateEx>();
        gen.addSigner(internalCert.getPrivateKey(), (X509Certificate)internalCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable((DEREncodableVector)signedAttrs), null);
        certList.add(internalCert);
        MimeMultipart retVal = null;
        CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        gen.addCertificatesAndCRLs(certsAndcrls);
        this._certStores.add(certsAndcrls);
        this._signers.add(new Signer(internalCert.getPrivateKey(), (X509Certificate)internalCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable((DEREncodableVector)signedAttrs), null));
        retVal = this.generate(partToSign, "BC");
        for (int i = 0; i < 10; ++i) {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            retVal.writeTo((OutputStream)oStream);
            oStream.flush();
            byte[] serialzedBytes = oStream.toByteArray();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(serialzedBytes, retVal.getContentType());
            MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
            Object signed = null;
            CMSSignedData signeddata = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPartInbound((BodyPart)partToSign), verifyMM.getBodyPart(1).getInputStream());
            int verified = 0;
            CertStore certs = signeddata.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = signeddata.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
                Attribute dig = signer.getSignedAttributes().get(CMSAttributes.messageDigest);
                DERObject hashObj = dig.getAttrValues().getObjectAt(0).getDERObject();
                byte[] signedHash = ((ASN1OctetString)hashObj).getOctets();
                System.out.print("value of signedHash: \r\n\tvalue: ");
                for (byte bt : signedHash) {
                    System.out.print(bt + " ");
                }
                System.out.println();
                Iterator<? extends Certificate> certIt = certCollection.iterator();
                try {
                    SigTest.assertTrue((boolean)signer.verify((X509Certificate)internalCert, "BC"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                byte[] bytes = signer.getContentDigest();
                ++verified;
            }
        }
    }

    private MimeMultipart generate(MimeBodyPart content, String prov) throws Exception {
        return this.make(this.makeContentBodyPart(content), prov);
    }

    private MimeMultipart make(MimeBodyPart content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent((Object)new ContentSigner(content, false, sigProvider), DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer header = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            this.addHashHeader(header, this._signers);
            MimeMultipart mm = new MimeMultipart(header.toString());
            mm.addBodyPart((BodyPart)content);
            mm.addBodyPart((BodyPart)sig);
            return mm;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)e));
        }
    }

    private MimeBodyPart makeContentBodyPart(MimeBodyPart content) throws SMIMEException {
        try {
            Header hdr;
            MimeMessage msg = new MimeMessage((Session)null);
            Enumeration e = content.getAllHeaders();
            msg.setDataHandler(content.getDataHandler());
            while (e.hasMoreElements()) {
                hdr = (Header)e.nextElement();
                msg.setHeader(hdr.getName(), hdr.getValue());
            }
            msg.saveChanges();
            e = msg.getAllHeaders();
            while (e.hasMoreElements()) {
                hdr = (Header)e.nextElement();
                if (!Strings.toLowerCase((String)hdr.getName()).startsWith("content-")) continue;
                content.setHeader(hdr.getName(), hdr.getValue());
            }
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)e));
        }
        return content;
    }

    private void addHashHeader(StringBuffer header, List signers) {
        int count = 0;
        Iterator it = signers.iterator();
        HashSet<String> micAlgs = new HashSet<String>();
        while (it.hasNext()) {
            Signer signer = (Signer)it.next();
            if (signer.getDigestOID().equals(DIGEST_SHA1)) {
                micAlgs.add("sha1");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_MD5)) {
                micAlgs.add("md5");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_SHA224)) {
                micAlgs.add("sha224");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_SHA256)) {
                micAlgs.add("sha256");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_SHA384)) {
                micAlgs.add("sha384");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_SHA512)) {
                micAlgs.add("sha512");
                continue;
            }
            if (signer.getDigestOID().equals(DIGEST_GOST3411)) {
                micAlgs.add("gostr3411-94");
                continue;
            }
            micAlgs.add("unknown");
        }
        for (String alg : micAlgs) {
            if (count == 0) {
                if (micAlgs.size() != 1) {
                    header.append("; micalg=\"");
                } else {
                    header.append("; micalg=");
                }
            } else {
                header.append(',');
            }
            header.append(alg);
            ++count;
        }
        if (count != 0 && micAlgs.size() != 1) {
            header.append('\"');
        }
    }

    static void outputPreamble(LineOutputStream lOut, MimeBodyPart part, String boundary) throws MessagingException, IOException {
        String line;
        InputStream in;
        try {
            in = part.getRawInputStream();
        }
        catch (MessagingException e) {
            return;
        }
        while ((line = SigTest.readLine(in)) != null && !line.equals(boundary)) {
            lOut.writeln(line);
        }
        in.close();
        if (line == null) {
            throw new MessagingException("no boundary found");
        }
    }

    private static String readLine(InputStream in) throws IOException {
        int ch;
        StringBuffer b = new StringBuffer();
        while ((ch = in.read()) >= 0 && ch != 10) {
            if (ch == 13) continue;
            b.append((char)ch);
        }
        if (ch < 0) {
            return null;
        }
        return b.toString();
    }

    static boolean isCanonicalisationRequired(MimeBodyPart bodyPart, String defaultContentTransferEncoding) throws MessagingException {
        String[] cte = bodyPart.getHeader("Content-Transfer-Encoding");
        String contentTransferEncoding = cte == null ? defaultContentTransferEncoding : cte[0];
        return !contentTransferEncoding.equalsIgnoreCase("binary");
    }

    static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputstream) {
            super(outputstream);
        }

        public void writeln(String s) throws MessagingException {
            try {
                byte[] abyte0 = LineOutputStream.getBytes(s);
                this.out.write(abyte0);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String s) {
            char[] ac = s.toCharArray();
            int i = ac.length;
            byte[] abyte0 = new byte[i];
            int j = 0;
            while (j < i) {
                abyte0[j] = (byte)ac[j++];
            }
            return abyte0;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }

    class Signer {
        final PrivateKey key;
        final X509Certificate cert;
        final String digestOID;
        final AttributeTable signedAttr;
        final AttributeTable unsignedAttr;

        Signer(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.signedAttr = signedAttr;
            this.unsignedAttr = unsignedAttr;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public String getDigestOID() {
            return this.digestOID;
        }

        public PrivateKey getKey() {
            return this.key;
        }

        public AttributeTable getSignedAttr() {
            return this.signedAttr;
        }

        public AttributeTable getUnsignedAttr() {
            return this.unsignedAttr;
        }
    }

    private class ContentSigner
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private final boolean _encapsulate;
        private final String _provider;

        ContentSigner(MimeBodyPart content, boolean encapsulate, String provider) {
            this._content = content;
            this._encapsulate = encapsulate;
            this._provider = provider;
        }

        protected CMSSignedDataStreamGenerator getGenerator() throws CMSException, CertStoreException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            Iterator it = SigTest.this._certStores.iterator();
            while (it.hasNext()) {
                gen.addCertificatesAndCRLs((CertStore)it.next());
            }
            it = SigTest.this._attributeCerts.iterator();
            while (it.hasNext()) {
                gen.addAttributeCertificates((X509Store)it.next());
            }
            for (Signer signer : SigTest.this._signers) {
                gen.addSigner(signer.getKey(), signer.getCert(), signer.getDigestOID(), signer.getSignedAttr(), signer.getUnsignedAttr(), this._provider);
            }
            gen.addSigners(new SignerInformationStore((Collection)SigTest.this._oldSigners));
            return gen;
        }

        private void writeBodyPart(OutputStream out, MimeBodyPart bodyPart) throws IOException, MessagingException {
            if (bodyPart.getContent() instanceof Multipart) {
                Multipart mp = (Multipart)bodyPart.getContent();
                ContentType contentType = new ContentType(mp.getContentType());
                String boundary = "--" + contentType.getParameter("boundary");
                LineOutputStream lOut = new LineOutputStream(out);
                Enumeration headers = bodyPart.getAllHeaderLines();
                while (headers.hasMoreElements()) {
                    lOut.writeln((String)headers.nextElement());
                }
                lOut.writeln();
                SigTest.outputPreamble(lOut, bodyPart, boundary);
                for (int i = 0; i < mp.getCount(); ++i) {
                    lOut.writeln(boundary);
                    this.writeBodyPart(out, (MimeBodyPart)mp.getBodyPart(i));
                    lOut.writeln();
                }
                lOut.writeln(boundary + "--");
            } else {
                if (SigTest.isCanonicalisationRequired(bodyPart, "7bit")) {
                    out = new CRLFOutputStream(out);
                }
                bodyPart.writeTo(out);
            }
        }

        public void write(OutputStream out) throws IOException {
            try {
                CMSSignedDataStreamGenerator gen = this.getGenerator();
                OutputStream signingStream = gen.open(out, this._encapsulate);
                if (this._content != null) {
                    if (!this._encapsulate) {
                        this.writeBodyPart(signingStream, this._content);
                    } else {
                        this._content.writeTo(signingStream);
                    }
                }
                signingStream.close();
                SigTest.this._digests = gen.getGeneratedDigests();
                for (Map.Entry entry : SigTest.this._digests.entrySet()) {
                    byte[] bytes = (byte[])entry.getValue();
                    System.out.print("digest of content: \r\n\tOID:" + entry.getKey() + "\r\n\tValue: ");
                    for (byte bt : bytes) {
                        System.out.print(bt + " ");
                    }
                    System.out.println();
                }
            }
            catch (MessagingException e) {
                throw new IOException(e.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.toString());
            }
            catch (NoSuchProviderException e) {
                throw new IOException(e.toString());
            }
            catch (CMSException e) {
                throw new IOException(e.toString());
            }
            catch (InvalidKeyException e) {
                throw new IOException(e.toString());
            }
            catch (CertStoreException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

