/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.cert.RevocationManager;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class CRLRevocationManager
implements RevocationManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultNHINDAgent.class);
    private static final int CRL_FETCH_TIMEOUT = 3000;
    private Set<CRL> crlCollection = new HashSet<CRL>();
    private static CertificateFactory certificateFactory;
    private static Map<String, X509CRLImpl> cache;

    private Set<CRL> getCRLCollection() {
        return Collections.unmodifiableSet(this.crlCollection);
    }

    private void loadCRLs(X509Certificate certificate) {
        block6: {
            if (certificate == null) {
                return;
            }
            try {
                X509CertImpl certificateImpl = new X509CertImpl(certificate.getEncoded());
                CRLDistributionPointsExtension crlDistributionPointsExtension = certificateImpl.getCRLDistributionPointsExtension();
                if (crlDistributionPointsExtension != null) {
                    for (DistributionPoint distributionPoint : (List)crlDistributionPointsExtension.get("points")) {
                        for (GeneralName generalName : distributionPoint.getFullName().names()) {
                            String crlURLString;
                            X509CRLImpl crlImpl;
                            String generalNameString = generalName.toString();
                            if (!generalNameString.startsWith("URIName: ") || (crlImpl = this.getCrlFromUri(crlURLString = this.getNameString(generalNameString))) == null) continue;
                            this.crlCollection.add(crlImpl);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn((Object)("Unable to handle CDP CRL(s): " + e.getMessage()));
            }
        }
    }

    @Override
    public boolean isRevoked(X509Certificate certificate) {
        this.loadCRLs(certificate);
        for (CRL crl : this.getCRLCollection()) {
            if (!crl.isRevoked(certificate)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRLImpl getCrlFromUri(String crlUrlString) {
        if (crlUrlString == null || crlUrlString.trim().length() == 0) {
            return null;
        }
        Map<String, X509CRLImpl> map = cache;
        synchronized (map) {
            X509CRLImpl crlImpl;
            block12: {
                crlImpl = cache.get(crlUrlString);
                if (crlImpl != null && crlImpl.getNextUpdate().before(new Date())) {
                    cache.remove(crlUrlString);
                    crlImpl = null;
                }
                if (crlImpl == null) {
                    try {
                        URLConnection urlConnection = new URL(crlUrlString).openConnection();
                        urlConnection.setConnectTimeout(3000);
                        InputStream crlInputStream = urlConnection.getInputStream();
                        try {
                            crlImpl = (X509CRLImpl)certificateFactory.generateCRL(crlInputStream);
                        }
                        finally {
                            crlInputStream.close();
                        }
                        cache.put(crlUrlString, crlImpl);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block12;
                        LOGGER.warn((Object)("Unable to retrieve or parse CRL " + crlUrlString));
                    }
                }
            }
            return crlImpl;
        }
    }

    protected String getNameString(String generalNameString) {
        return generalNameString.substring(9);
    }

    static {
        cache = new HashMap<String, X509CRLImpl>();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }
}

