/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import com.google.inject.Inject;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.Thumbprint;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;

public class LDAPCertificateStore
extends CertificateStore
implements CacheableCertStore {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(LDAPCertificateStore.class);
    private static final String CACHE_NAME = "LDAP_REMOTE_CERT_CACHE";
    private CertificateStore localStoreDelegate;
    private JCS cache;
    private CertStoreCachePolicy cachePolicy;
    private LdapCertUtilImpl ldapCertUtil;

    public LDAPCertificateStore() {
        this.localStoreDelegate = this.createDefaultLocalStore();
        this.loadBootStrap();
    }

    @Inject
    public LDAPCertificateStore(LdapCertUtilImpl ldapCertUtil, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        this.ldapCertUtil = ldapCertUtil;
        this.cachePolicy = policy;
        this.localStoreDelegate = bootstrapStore == null ? this.createDefaultLocalStore() : bootstrapStore;
        this.loadBootStrap();
    }

    protected synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = JCS.getInstance((String)(CACHE_NAME + UUID.randomUUID()));
            this.applyCachePolicy(this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultLDAPCachePolicy();
    }

    protected CertificateStore createDefaultLocalStore() {
        KeyStoreCertificateStore retVal = new KeyStoreCertificateStore(new File("NHINKeyStore"), "nH!NdK3yStor3", "31visl!v3s");
        return retVal;
    }

    @Override
    public void add(X509Certificate cert) {
        if (this.contains(cert)) {
            throw new IllegalArgumentException("Cert already contained in store.  Use update() to update a certificate");
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        String subject = CryptoExtensions.getSubjectAddress(cert);
        Collection<X509Certificate> foundCerts = subject == null || subject.isEmpty() ? this.getAllCertificates() : this.getCertificates(subject);
        if (foundCerts != null) {
            Thumbprint searchCertTP = Thumbprint.toThumbprint(cert);
            for (X509Certificate foundCert : foundCerts) {
                if (!Thumbprint.toThumbprint(foundCert).equals(searchCertTP)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection<X509Certificate> retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection<X509Certificate>)cache.get((Object)realSubjectName);
            if (retVal == null || retVal.size() == 0) {
                retVal = this.ldapCertUtil.ldapSearch(realSubjectName);
                if (retVal != null && retVal.size() > 0) {
                    if (!subjectName.contains("*")) {
                        try {
                            cache.putSafe((Object)realSubjectName, retVal);
                        }
                        catch (CacheException e) {
                            LOGGER.error((Object)("Error adding certificates to the cache: " + e.getMessage()), (Throwable)e);
                        }
                        if (this.localStoreDelegate != null) {
                            this.addOrUpdateLocalStoreDelegate(retVal);
                        }
                    }
                } else if (this.localStoreDelegate != null) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                }
            }
        } else {
            retVal = this.ldapCertUtil.ldapSearch(realSubjectName);
            if (this.localStoreDelegate != null) {
                if (retVal == null || retVal.size() == 0) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                } else if (!subjectName.contains("*")) {
                    this.addOrUpdateLocalStoreDelegate(retVal);
                }
            }
        }
        return retVal;
    }

    protected void addOrUpdateLocalStoreDelegate(Collection<X509Certificate> retVal) {
        if (retVal != null && this.localStoreDelegate != null) {
            for (X509Certificate cert : retVal) {
                if (this.localStoreDelegate.contains(cert)) {
                    this.localStoreDelegate.update(cert);
                    continue;
                }
                this.localStoreDelegate.add(cert);
            }
        }
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        return this.getCertificates("*");
    }

    @Override
    public void remove(X509Certificate cert) {
    }

    @Override
    public void flush(boolean purgeBootStrap) {
    }

    @Override
    public void loadBootStrap() {
    }

    @Override
    public void loadBootStrap(CertificateStore bootstrapStore) {
    }

    @Override
    public void setBootStrap(CertificateStore bootstrapStore) {
    }

    @Override
    public void setCachePolicy(CertStoreCachePolicy policy) {
    }

    private static class DefaultLDAPCachePolicy
    implements CertStoreCachePolicy {
        private DefaultLDAPCachePolicy() {
        }

        @Override
        public int getMaxItems() {
            return 1000;
        }

        @Override
        public int getSubjectTTL() {
            return 86400;
        }
    }
}

