/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.CryptoExtensions;

public class CreatePKCS12 {
    private static File certFile;
    private static File keyFile;
    private static String password;
    private static File createFile;

    public static void main(String[] argv) {
        if (argv.length == 0) {
            CreatePKCS12.printUsage();
            System.exit(-1);
        }
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                CreatePKCS12.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-cert")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing X509 certificate file.");
                    System.exit(-1);
                }
                certFile = new File(argv[++i]);
                continue;
            }
            if (arg.equals("-key")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing PCKS8 key file.");
                    System.exit(-1);
                }
                keyFile = new File(argv[++i]);
                continue;
            }
            if (arg.equals("-password")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing key file password.");
                    System.exit(-1);
                }
                password = argv[++i];
                continue;
            }
            if (arg.equals("-out")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing output file.");
                    System.exit(-1);
                }
                createFile = new File(argv[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                CreatePKCS12.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            CreatePKCS12.printUsage();
            System.exit(-1);
        }
        if (CreatePKCS12.validateParameters() && CreatePKCS12.create(certFile, keyFile, password, createFile) != null) {
            System.out.println("Create pcks12 file " + createFile.getAbsolutePath());
        }
        System.exit(0);
    }

    private static boolean validateParameters() {
        return certFile != null && keyFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File create(File certFile, File keyFile, String password, File createFile) {
        File pkcs12File = null;
        CreatePKCS12.certFile = certFile;
        CreatePKCS12.keyFile = keyFile;
        FileOutputStream outStr = null;
        InputStream inStr = null;
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
            localKeyStore.load(null, null);
            byte[] certData = CreatePKCS12.loadFileData(certFile);
            byte[] keyData = CreatePKCS12.loadFileData(keyFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            inStr = new ByteArrayInputStream(certData);
            Certificate cert = cf.generateCertificate(inStr);
            inStr.close();
            KeyFactory kf = KeyFactory.getInstance("RSA", CryptoExtensions.getJCEProviderName());
            PKCS8EncodedKeySpec keysp = null;
            if (password != null && !password.isEmpty()) {
                EncryptedPrivateKeyInfo encInfo = new EncryptedPrivateKeyInfo(keyData);
                PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
                String alg = encInfo.getAlgName();
                SecretKeyFactory secFactory = SecretKeyFactory.getInstance(alg, CryptoExtensions.getJCEProviderName());
                SecretKey secKey = secFactory.generateSecret(keySpec);
                keysp = encInfo.getKeySpec((Key)secKey, CryptoExtensions.getJCEProviderName());
            } else {
                keysp = new PKCS8EncodedKeySpec(keyData);
            }
            PrivateKey privKey = kf.generatePrivate(keysp);
            char[] array = "".toCharArray();
            localKeyStore.setKeyEntry("privCert", privKey, array, new Certificate[]{cert});
            pkcs12File = CreatePKCS12.getPKCS12OutFile(createFile);
            outStr = new FileOutputStream(pkcs12File);
            localKeyStore.store(outStr, array);
        }
        catch (Exception e) {
            System.err.println("Failed to create pcks12 file: " + e.getMessage());
            e.printStackTrace(System.err);
            File file = null;
            return file;
        }
        finally {
            if (outStr != null) {
                try {
                    outStr.close();
                }
                catch (Exception e) {}
            }
            if (outStr != null) {
                try {
                    inStr.close();
                }
                catch (Exception e) {}
            }
        }
        return pkcs12File;
    }

    private static File getPKCS12OutFile(File createFile) throws Exception {
        if (createFile == null) {
            String fileName = certFile.getName();
            int index = fileName.lastIndexOf(".");
            if (index > -1) {
                fileName = fileName.substring(0, index);
            }
            fileName = fileName + ".p12";
            createFile = new File(fileName);
        }
        if (createFile.exists()) {
            createFile.delete();
        }
        createFile.createNewFile();
        return createFile;
    }

    private static byte[] loadFileData(File file) throws Exception {
        return FileUtils.readFileToByteArray((File)file);
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java CreatePKCS12 (options)...\n\n");
        use.append("options:\n");
        use.append("-cert X509 File\t\tX509 DER formatted certificate file.\n");
        use.append("\n");
        use.append("-key  Key File\t\tPCKS8 DER formatted private key file.\n");
        use.append("\n");
        use.append("-pass Passwd\t\tOptional passphrase for private key file.\n");
        use.append("\t\t\tDefault: \"\"\n\n");
        use.append("-out  Out File\t\tOptional output file name.\n");
        use.append("\t\t\tDefault: <CertFileName>.pkcs12\n\n");
        System.err.println(use);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

