/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.mail.MimeStandard;
import org.nhindirect.stagent.parser.EntitySerializer;

public class Message
extends MimeMessage {
    Message() {
        super((Session)null);
    }

    public Message(InternetHeaders headers, byte[] content) throws MessagingException {
        super(null, Message.toInputStream(headers, content));
    }

    private static InputStream toInputStream(InternetHeaders headers, byte[] content) throws MessagingException {
        MimeBodyPart prt = new MimeBodyPart(headers, content);
        return new ByteArrayInputStream(EntitySerializer.Default.serializeToBytes((MimePart)prt));
    }

    public Message(MimeMessage message) throws MessagingException {
        super(message);
    }

    public Message(InputStream inStream) throws MessagingException {
        super(null, inStream);
    }

    private String getRawHeaderLine(String headerName) {
        try {
            Enumeration headers = this.getMatchingHeaderLines(new String[]{headerName});
            if (headers != null && headers.hasMoreElements()) {
                return (String)headers.nextElement();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public String getToHeader() {
        return this.getRawHeaderLine("to");
    }

    public String getCCHeader() {
        return this.getRawHeaderLine("cc");
    }

    public String getBCCHeader() {
        return this.getRawHeaderLine("bcc");
    }

    public String getFromHeader() {
        return this.getRawHeaderLine("from");
    }

    public String getSubjectHeader() {
        return this.getRawHeaderLine("subject");
    }

    public String getIDHeader() {
        return this.getRawHeaderLine("message-id");
    }

    public String getDateHeader() {
        return this.getRawHeaderLine("date");
    }

    public MimeEntity extractMimeEntity() {
        MimeEntity retVal = null;
        try {
            InternetHeaders headers = new InternetHeaders();
            if (this.headers.getAllHeaders().hasMoreElements()) {
                Enumeration hEnum = this.headers.getAllHeaders();
                while (hEnum.hasMoreElements()) {
                    Header hdr = (Header)hEnum.nextElement();
                    if (!MimeStandard.startsWith(hdr.getName(), "Content-")) continue;
                    headers.addHeader(hdr.getName(), hdr.getValue());
                }
                if (!headers.getAllHeaders().hasMoreElements()) {
                    throw new MimeException(MimeError.InvalidMimeEntity);
                }
                retVal = new MimeEntity(headers, this.getContentAsBytes());
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        return retVal;
    }

    public MimeEntity extractEntityForSignature(boolean includeEpilogue) {
        if (includeEpilogue || !this.isMultiPart()) {
            return this.extractMimeEntity();
        }
        return null;
    }

    public String toString() {
        return EntitySerializer.Default.serialize((MimePart)this);
    }

    public byte[] getContentAsBytes() {
        byte[] retVal = null;
        try {
            int read;
            InputStream inStream = this.getRawInputStream();
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((read = inStream.read(buffer)) > -1) {
                oStream.write(buffer, 0, read);
            }
            retVal = oStream.toByteArray();
            oStream.close();
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidBody, e);
        }
        return retVal;
    }

    private boolean isMultiPart() {
        String contentType;
        try {
            contentType = this.getContentType();
        }
        catch (MessagingException e) {
            return false;
        }
        if (contentType == null || contentType.length() == 0) {
            return false;
        }
        return MimeStandard.contains(contentType, "multipart");
    }
}

