/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimePart;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.parser.EntitySerializer;

public class WrappedMessage {
    private static InternetHeaders copyHeaders(Message message, String[] headersToCopy) throws MessagingException {
        InternetHeaders retVal = new InternetHeaders();
        Enumeration hdEnum = message.getMatchingHeaderLines(headersToCopy);
        while (hdEnum.hasMoreElements()) {
            retVal.addHeaderLine((String)hdEnum.nextElement());
        }
        return retVal;
    }

    public static Message create(Message message, String[] headersToCopy) throws MessagingException {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        InternetHeaders copiedHeaders = WrappedMessage.copyHeaders(message, headersToCopy);
        copiedHeaders.setHeader("content-type", "message/rfc822");
        return new Message(copiedHeaders, EntitySerializer.Default.serializeToBytes((MimePart)message));
    }

    public static Message create(String message, String[] headersToCopy) throws MessagingException {
        if (message == null || message.length() == 0) {
            throw new IllegalArgumentException("Message cannot be null or empty");
        }
        Message msg = new Message(EntitySerializer.Default.deserialize(message));
        return WrappedMessage.create(msg, headersToCopy);
    }

    public static boolean isWrapped(Message message) {
        if (message == null) {
            return false;
        }
        try {
            return message.getContentType().equalsIgnoreCase("message/rfc822");
        }
        catch (MessagingException messagingException) {
            return false;
        }
    }

    public static Message extract(Message message) throws MessagingException {
        if (!WrappedMessage.isWrapped(message)) {
            throw new MimeException(MimeError.ContentTypeMismatch);
        }
        byte[] body = message.getContentAsBytes();
        if (body == null || body.length == 0) {
            throw new MimeException(MimeError.MissingBody);
        }
        return new Message(EntitySerializer.Default.deserialize(body));
    }
}

