/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import org.nhindirect.stagent.mail.notifications.NotificationHelper;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.SendType;
import org.nhindirect.stagent.mail.notifications.TriggerType;

public class Disposition {
    private final TriggerType triggerType;
    private final SendType sendType;
    private NotificationType notification;
    private boolean error;

    public Disposition(NotificationType notification) {
        this(TriggerType.Automatic, SendType.Automatic, notification);
    }

    public Disposition(TriggerType triggerType, SendType sendType, NotificationType notification) {
        this.triggerType = triggerType;
        this.sendType = sendType;
        this.notification = notification;
        this.error = false;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public NotificationType getNotification() {
        return this.notification;
    }

    public void setNotification(NotificationType notification) {
        this.notification = notification;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public SendType getSendType() {
        return this.sendType;
    }

    public String toString() {
        StringBuilder notification = new StringBuilder();
        notification.append(NotificationHelper.asString(this.triggerType));
        notification.append('/');
        notification.append(NotificationHelper.asString(this.sendType));
        notification.append(';');
        notification.append(NotificationHelper.asString(this.notification));
        if (this.isError()) {
            notification.append('/');
            notification.append("error");
        }
        return notification.toString();
    }
}

