/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;

public class Notification {
    private static final String DefaultExplanation = "Your message was successfully ";
    private MimeEntity explanation;
    private MimeEntity notification;
    private ReportingUserAgent reportingAgent;
    private MdnGateway gateway;
    private Disposition disposition;
    private MimeMultipart mmRep;
    private String finalRecipient;

    public Notification(NotificationType notification) {
        this(new Disposition(notification));
    }

    public Notification(Disposition disposition) {
        try {
            this.explanation = new MimeEntity();
            this.explanation.setHeader("Content-Type", "text/plain");
            this.notification = new MimeEntity();
            this.notification.setHeader("Content-Type", "message/disposition-notification");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.setDisposition(disposition, true);
    }

    public String getExplanation() {
        String retVal = "";
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.explanation.writeTo(os);
            retVal = new String(os.toByteArray(), "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (MessagingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retVal;
    }

    public void setExplanation(String explanation) {
        try {
            this.explanation.setText(explanation);
            this.genMMRep();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public ReportingUserAgent getReportingAgent() {
        return this.reportingAgent;
    }

    public void setReportingAgent(ReportingUserAgent reportingAgent) {
        try {
            if (reportingAgent != null) {
                this.notification.setHeader("Reporting-UA", reportingAgent.toString());
            } else {
                this.notification.removeHeader("Reporting-UA");
            }
            this.genMMRep();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.reportingAgent = reportingAgent;
    }

    public MdnGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(MdnGateway gateway) {
        try {
            if (gateway != null) {
                this.notification.setHeader("MDN-Gateway", gateway.toString());
            } else {
                this.notification.removeHeader("MDN-Gateway");
            }
            this.genMMRep();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.gateway = gateway;
    }

    public String getOriginalMessageId() {
        String retVal = null;
        try {
            retVal = this.notification.getHeader("Original-Message-ID", null);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return retVal != null ? retVal : "";
    }

    public void setOriginalMessageId(String messageId) {
        if (messageId != null && !messageId.isEmpty()) {
            try {
                this.notification.setHeader("Original-Message-ID", messageId);
                this.genMMRep();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public String getFinalRecipeint() {
        return this.finalRecipient;
    }

    public void setFinalRecipient(String recip) {
        try {
            if (recip != null && !recip.isEmpty()) {
                this.notification.setHeader("Final-Recipient", recip);
            } else {
                this.notification.removeHeader("Final-Recipient");
            }
            this.genMMRep();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.finalRecipient = recip;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    private void setDisposition(Disposition disposition, boolean supressMMGen) {
        if (disposition == null) {
            throw new IllegalArgumentException("value");
        }
        try {
            this.notification.setHeader("Disposition", disposition.toString());
            if (!supressMMGen) {
                this.genMMRep();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.disposition = disposition;
    }

    public void setDisposition(Disposition disposition) {
        this.setDisposition(disposition, false);
    }

    public String getError() {
        String retVal = null;
        try {
            String[] headers = this.notification.getHeader("Error");
            if (headers != null && headers.length > 0) {
                retVal = headers[0];
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return retVal;
    }

    public void setError(String error) {
        if (error != null && !error.isEmpty()) {
            try {
                this.notification.setHeader("Error", error);
                this.genMMRep();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public Collection<MimeEntity> getParts() {
        ArrayList<MimeEntity> retVal = new ArrayList<MimeEntity>();
        if (this.getExplanation().trim().isEmpty()) {
            this.setExplanation(DefaultExplanation + (Object)((Object)this.disposition.getNotification()));
        }
        retVal.add(this.explanation);
        retVal.add(this.notification);
        return retVal;
    }

    public MimeMultipart getAsMultipart() {
        if (this.mmRep == null) {
            this.genMMRep();
        }
        return this.mmRep;
    }

    public byte[] serializeToBytes() {
        if (this.mmRep == null) {
            this.genMMRep();
        }
        ByteArrayOutputStream oStream = null;
        try {
            oStream = new ByteArrayOutputStream();
            this.mmRep.writeTo((OutputStream)oStream);
            oStream.flush();
        }
        catch (MessagingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return oStream.toByteArray();
    }

    public InputStream getInputStream() {
        if (this.mmRep == null) {
            this.genMMRep();
        }
        ByteArrayOutputStream oStream = null;
        try {
            oStream = new ByteArrayOutputStream();
            this.mmRep.writeTo((OutputStream)oStream);
            oStream.flush();
        }
        catch (MessagingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(oStream.toByteArray());
    }

    private void genMMRep() {
        this.mmRep = new MimeMultipart();
        Collection<MimeEntity> parts = this.getParts();
        try {
            for (MimeEntity part : parts) {
                this.mmRep.addBodyPart((BodyPart)part);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

