/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationHelper;

public class NotificationMessage
extends Message {
    public NotificationMessage(String to, Notification notification) throws MessagingException {
        this(to, null, notification);
    }

    public NotificationMessage(String to, String from, Notification notification) throws MessagingException {
        super(NotificationMessage.createHeaders(to, from, notification), notification.serializeToBytes());
    }

    private static InternetHeaders createHeaders(String to, String from, Notification notification) throws MessagingException {
        InternetHeaders headers = new InternetHeaders();
        if (to != null && !to.isEmpty()) {
            headers.addHeader("to", to);
        }
        if (from != null && !from.isEmpty()) {
            headers.addHeader("from", from);
        }
        headers.addHeader("MIME-Version", "1.0");
        ContentType type = new ContentType(notification.getAsMultipart().getContentType());
        String boundary = type.getParameter("boundary");
        headers.addHeader("content-type", "multipart/report; report-type=disposition-notification; boundary=\"" + boundary + "\"");
        return headers;
    }

    public static NotificationMessage createNotificationFor(Message message, Notification notification) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        if (notification == null) {
            throw new IllegalArgumentException();
        }
        if (NotificationHelper.isMDN(message)) {
            throw new IllegalArgumentException("Message is an MDN");
        }
        String notifyTo = NotificationHelper.getNotificationDestination(message);
        if (notifyTo == null || notifyTo.isEmpty()) {
            throw new IllegalArgumentException("Invalid Disposition-Notification-To Header");
        }
        NotificationMessage notificationMessage = null;
        try {
            String originalMessageID = message.getMessageID();
            if (originalMessageID != null && !originalMessageID.isEmpty()) {
                notification.setOriginalMessageId(originalMessageID);
            }
            notificationMessage = new NotificationMessage(notifyTo, notification);
            notificationMessage.setHeader("message-id", UUID.randomUUID().toString());
            String subject = message.getHeader("subject", ",");
            if (subject == null) {
                subject = "";
            }
            notificationMessage.setHeader("subject", "Processed: " + subject);
        }
        catch (MessagingException e) {
            // empty catch block
        }
        return notificationMessage;
    }
}

