/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.SignerCertPair;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;

public class TrustModel {
    public static final TrustModel Default = new TrustModel();
    private final TrustChainValidator certChainValidator;

    public TrustModel() {
        this.certChainValidator = new TrustChainValidator();
    }

    @Inject
    public TrustModel(TrustChainValidator validator) {
        this.certChainValidator = validator;
    }

    public TrustChainValidator getCertChainValidator() {
        return this.certChainValidator;
    }

    public void enforce(IncomingMessage message) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        if (!message.hasSignatures()) {
            throw new AgentException(AgentError.UntrustedMessage);
        }
        this.findSenderSignatures(message);
        if (!message.hasSenderSignatures()) {
            throw new AgentException(AgentError.MissingSenderSignature);
        }
        NHINDAddressCollection recipients = message.getDomainRecipients();
        for (NHINDAddress recipient : recipients) {
            recipient.setStatus(TrustEnforcementStatus.Failed);
            DefaultMessageSignatureImpl trustedSignature = this.findTrustedSignature(message, recipient.getTrustAnchors());
            if (trustedSignature == null) continue;
            recipient.setStatus(trustedSignature.isThumbprintVerified() ? TrustEnforcementStatus.Success : TrustEnforcementStatus.Success_ThumbprintMismatch);
        }
    }

    public void enforce(OutgoingMessage message) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        NHINDAddress sender = message.getSender();
        NHINDAddressCollection recipients = message.getRecipients();
        for (NHINDAddress recipient : recipients) {
            recipient.setStatus(TrustEnforcementStatus.Failed);
            recipient.setCertificates(this.findTrustedCerts(recipient.getCertificates(), sender.getTrustAnchors()));
            if (!recipient.hasCertificates()) continue;
            recipient.setStatus(TrustEnforcementStatus.Success);
        }
    }

    protected Collection<X509Certificate> findTrustedCerts(Collection<X509Certificate> certs, Collection<X509Certificate> anchors) {
        if (certs == null) {
            return null;
        }
        ArrayList<X509Certificate> trustedCerts = null;
        for (X509Certificate cert : certs) {
            if (!this.certChainValidator.isTrusted(cert, anchors)) continue;
            if (trustedCerts == null) {
                trustedCerts = new ArrayList<X509Certificate>();
            }
            trustedCerts.add(cert);
        }
        return trustedCerts;
    }

    protected void findSenderSignatures(IncomingMessage message) {
        message.setSenderSignatures(null);
        NHINDAddress sender = message.getSender();
        ArrayList<DefaultMessageSignatureImpl> senderSignatures = new ArrayList<DefaultMessageSignatureImpl>();
        Collection<SignerCertPair> individualSenders = CryptoExtensions.findSignersByName(message.getSignature(), sender.getAddress(), null);
        Collection<SignerCertPair> orgSenders = CryptoExtensions.findSignersByName(message.getSignature(), sender.getHost(), Arrays.asList(sender.getAddress()));
        for (SignerCertPair pair : individualSenders) {
            senderSignatures.add(new DefaultMessageSignatureImpl(pair.getSigner(), false, pair.getCertificate()));
        }
        for (SignerCertPair pair : orgSenders) {
            senderSignatures.add(new DefaultMessageSignatureImpl(pair.getSigner(), true, pair.getCertificate()));
        }
        message.setSenderSignatures(senderSignatures);
    }

    protected DefaultMessageSignatureImpl findTrustedSignature(IncomingMessage message, Collection<X509Certificate> anchors) {
        NHINDAddress sender = message.getSender();
        Collection<DefaultMessageSignatureImpl> signatures = message.getSenderSignatures();
        DefaultMessageSignatureImpl lastTrustedSignature = null;
        for (DefaultMessageSignatureImpl signature : signatures) {
            if (!this.certChainValidator.isTrusted(signature.getSignerCert(), anchors) || !signature.checkSignature()) continue;
            if (!sender.hasCertificates()) {
                return signature;
            }
            if (signature.checkThumbprint(sender)) {
                return signature;
            }
            lastTrustedSignature = signature;
        }
        return lastTrustedSignature;
    }
}

