/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.JCSAdapter;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.TestUtils;

public class LDAPCertificateStore_GetCertificates_Test
extends TestCase {
    public void testCacheIsNull_CertififcateIsRetrievedFromLdapServer() throws Exception {
        new CacheIsNull(){

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
            }
        }.perform();
    }

    public void testCacheIsNull_CorrectSubjectNameParamIsPassedToLdapSearchMethod() throws Exception {
        new CacheIsNull(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                Assert.assertEquals((String)this.theCreateSubjectName, (String)subjectName);
                return super.ldapSearch_Internal(subjectName);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
            }
        }.perform();
    }

    public void testLdapSearchReturnsNonEmptyCollection_AddOrUpdateLocalStoreDelegateMethodIsCalled() throws Exception {
        new CacheIsNull(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void addOrUpdateLocalStoreDelegate_Internal(Collection<X509Certificate> retVal) {
                Assert.assertEquals((Object)this.theLdapSearch, retVal);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.addOrUpdateLocalStoreDelegateCalls);
                Assert.assertEquals((Object)this.theLdapSearch, getCertificates);
            }
        }.perform();
    }

    public void testLdapGetWildcardReturnsNonEmptyCollection_AddOrUpdateLocalStoreDelegateMethodNoCalled() throws Exception {
        new CacheIsNull(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void addOrUpdateLocalStoreDelegate_Internal(Collection<X509Certificate> retVal) {
                Assert.assertEquals((Object)this.theLdapSearch, retVal);
            }

            @Override
            protected String createSubjectName() throws Exception {
                this.theCreateSubjectName = "*";
                return this.theCreateSubjectName;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)0, (int)this.addOrUpdateLocalStoreDelegateCalls);
                Assert.assertEquals((Object)this.theLdapSearch, getCertificates);
            }
        }.perform();
    }

    public void testLdapSearchReturnsEmptyCollection_GetsCertificatesFromBootstrapStore() throws Exception {
        new CacheIsNull(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                return this.theLdapSearch;
            }

            @Override
            protected Collection<X509Certificate> getCertificates_Internal(String subjectName) {
                Assert.assertEquals((String)this.theCreateSubjectName, (String)subjectName);
                return super.getCertificates_Internal(subjectName);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)0, (int)this.addOrUpdateLocalStoreDelegateCalls);
                Assert.assertEquals((int)1, (int)this.getCertificatesCalls);
                Assert.assertEquals((Object)this.theGetCertificates, getCertificates);
            }
        }.perform();
    }

    public void testBootstrapStoreIsNull_AddOrUpdateLocalStoreDelegateIsNotCalled() throws Exception {
        new CacheIsNull(){

            @Override
            protected CertificateStore createBootstrapStore() {
                this.theCreateBootstrapStore = null;
                return this.theCreateBootstrapStore;
            }

            @Override
            protected CertificateStore createDefaultLocalStore_Internal() {
                this.theCreateDefaultLocalStore = null;
                return this.theCreateDefaultLocalStore;
            }

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
                Assert.assertEquals((int)0, (int)this.addOrUpdateLocalStoreDelegateCalls);
            }
        }.perform();
    }

    public void testCacheIsNotNull_AttemptsToGetCertificatesFromCache() throws Exception {
        new CacheIsNotNull(){

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.getCalls);
                Assert.assertEquals((Object)this.theGet, getCertificates);
            }
        }.perform();
    }

    public void testCertificateIsNotInCache_CertififcateIsRetrievedFromLdapServer() throws Exception {
        new CertificateIsNotPresentInCache(){

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
                Assert.assertNotSame((Object)this.theGet, getCertificates);
            }
        }.perform();
    }

    public void testCertificateIsRetrievedFromLdapServerAndAddedToCache() throws Exception {
        new CertificateIsNotPresentInCache(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void addOrUpdateLocalStoreDelegate_Internal(Collection<X509Certificate> retVal) {
                Assert.assertEquals((Object)this.theLdapSearch, retVal);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.putSafeCalls);
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
                Assert.assertEquals((int)1, (int)this.addOrUpdateLocalStoreDelegateCalls);
                Assert.assertEquals((Object)this.theLdapSearch, getCertificates);
            }
        }.perform();
    }

    public void testCertificateIsRetrievedFromLdapServerAddOrUpdateLocalStoreDelegateMethodIsCalled() throws Exception {
        new CertificateIsNotPresentInCache(){

            @Override
            protected void putSafe_Internal(Object key, Object value) throws CacheException {
                Assert.assertEquals((Object)this.theCreateSubjectName, (Object)key);
            }

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.putSafeCalls);
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
                Assert.assertNotSame((Object)this.theGet, getCertificates);
            }
        }.perform();
    }

    public void testLocalStoreDelegateIsNull_AddOrUpdateLocalStoreDelegateIsNotCalled() throws Exception {
        new CertificateIsNotPresentInCache(){

            @Override
            protected CertificateStore createBootstrapStore() {
                this.theCreateBootstrapStore = null;
                return this.theCreateBootstrapStore;
            }

            @Override
            protected CertificateStore createDefaultLocalStore_Internal() {
                this.theCreateDefaultLocalStore = null;
                return this.theCreateDefaultLocalStore;
            }

            @Override
            protected void putSafe_Internal(Object key, Object value) throws CacheException {
                Assert.assertEquals((Object)this.theCreateSubjectName, (Object)key);
            }

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = new ArrayList();
                try {
                    X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                    this.theLdapSearch.add(internalCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                return this.theLdapSearch;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)1, (int)this.putSafeCalls);
                Assert.assertEquals((int)1, (int)this.ldapSearchCalls);
                Assert.assertEquals((int)0, (int)this.addOrUpdateLocalStoreDelegateCalls);
            }
        }.perform();
    }

    public void testLdapSearchReturnsNullCollection_GetsCertificatesFromBootstrapStore() throws Exception {
        new CertificateIsNotPresentInCache(){

            @Override
            protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
                this.theLdapSearch = null;
                return this.theLdapSearch;
            }

            @Override
            protected Collection<X509Certificate> getCertificates_Internal(String subjectName) {
                Assert.assertEquals((String)this.theCreateSubjectName, (String)subjectName);
                return super.getCertificates_Internal(subjectName);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
                Assert.assertEquals((int)0, (int)this.putSafeCalls);
                Assert.assertEquals((int)1, (int)this.getCertificatesCalls);
                Assert.assertEquals((Object)this.theGetCertificates, getCertificates);
            }
        }.perform();
    }

    class CertificateIsNotPresentInCache
    extends TestPlan {
        protected Object theGet;
        protected int getCalls;
        protected int putSafeCalls;

        CertificateIsNotPresentInCache() {
            this.getCalls = 0;
            this.putSafeCalls = 0;
        }

        @Override
        protected JCS getCache_Internal() {
            this.theGetCache = new JCSAdapter(null){

                public Object get(Object name) {
                    ++CertificateIsNotPresentInCache.this.getCalls;
                    return CertificateIsNotPresentInCache.this.get_Internal(name);
                }

                public void putSafe(Object key, Object value) throws CacheException {
                    ++CertificateIsNotPresentInCache.this.putSafeCalls;
                    CertificateIsNotPresentInCache.this.putSafe_Internal(key, value);
                }
            };
            return this.theGetCache;
        }

        protected Object get_Internal(Object name) {
            this.theGet = new ArrayList();
            return this.theGet;
        }

        protected void putSafe_Internal(Object key, Object value) throws CacheException {
        }
    }

    class CacheIsNotNull
    extends TestPlan {
        protected Object theGet;
        protected int getCalls;

        CacheIsNotNull() {
            this.getCalls = 0;
        }

        @Override
        protected JCS getCache_Internal() {
            this.theGetCache = new JCSAdapter(null){

                public Object get(Object name) {
                    ++CacheIsNotNull.this.getCalls;
                    return CacheIsNotNull.this.get_Internal(name);
                }
            };
            return this.theGetCache;
        }

        protected Object get_Internal(Object name) {
            this.theGet = new ArrayList();
            try {
                X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
                ((List)this.theGet).add(internalCert);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            return this.theGet;
        }
    }

    class CacheIsNull
    extends TestPlan {
        CacheIsNull() {
        }

        @Override
        protected JCS getCache_Internal() {
            this.theGetCache = null;
            return this.theGetCache;
        }
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected JCS theGetCache;
        protected int getCacheCalls = 0;
        protected int addOrUpdateLocalStoreDelegateCalls = 0;
        protected CertificateStore theCreateDefaultLocalStore;
        protected int createDefaultLocalStoreCalls = 0;
        protected String theCreateSubjectName;
        protected LdapCertUtilImpl theCreateLdapCertUtil;
        protected int ldapSearchCalls = 0;
        protected Collection<X509Certificate> theLdapSearch;
        protected CertificateStore theCreateBootstrapStore;
        protected int getCertificatesCalls = 0;
        protected Collection<X509Certificate> theGetCertificates;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            LDAPCertificateStore impl = this.createLDAPCertificateStore();
            Collection getCertificates = impl.getCertificates(this.createSubjectName());
            this.doAssertions(getCertificates);
        }

        protected LDAPCertificateStore createLDAPCertificateStore() throws Exception {
            return new LDAPCertificateStore(this.createLdapCertUtil(), this.createBootstrapStore(), null){

                protected JCS getCache() {
                    ++TestPlan.this.getCacheCalls;
                    return TestPlan.this.getCache_Internal();
                }

                protected void addOrUpdateLocalStoreDelegate(Collection<X509Certificate> retVal) {
                    ++TestPlan.this.addOrUpdateLocalStoreDelegateCalls;
                    TestPlan.this.addOrUpdateLocalStoreDelegate_Internal(retVal);
                }

                protected CertificateStore createDefaultLocalStore() {
                    ++TestPlan.this.createDefaultLocalStoreCalls;
                    return TestPlan.this.createDefaultLocalStore_Internal();
                }
            };
        }

        protected JCS getCache_Internal() {
            try {
                this.theGetCache = JCS.getInstance((String)"");
            }
            catch (CacheException e) {
                e.printStackTrace();
                Assert.fail();
            }
            return this.theGetCache;
        }

        protected void addOrUpdateLocalStoreDelegate_Internal(Collection<X509Certificate> retVal) {
        }

        protected CertificateStore createDefaultLocalStore_Internal() {
            this.theCreateDefaultLocalStore = new KeyStoreCertificateStore();
            return this.theCreateDefaultLocalStore;
        }

        protected String createSubjectName() throws Exception {
            this.theCreateSubjectName = "createSubjectName";
            return this.theCreateSubjectName;
        }

        protected Collection<X509Certificate> ldapSearch_Internal(String subjectName) {
            this.theLdapSearch = new ArrayList<X509Certificate>();
            return this.theLdapSearch;
        }

        protected LdapCertUtilImpl createLdapCertUtil() {
            this.theCreateLdapCertUtil = new LdapCertUtilImpl(null, null, null){

                public Collection<X509Certificate> ldapSearch(String subjectName) {
                    ++TestPlan.this.ldapSearchCalls;
                    return TestPlan.this.ldapSearch_Internal(subjectName);
                }
            };
            return this.theCreateLdapCertUtil;
        }

        protected Collection<X509Certificate> getCertificates_Internal(String subjectName) {
            this.theGetCertificates = new ArrayList<X509Certificate>();
            return this.theGetCertificates;
        }

        protected CertificateStore createBootstrapStore() {
            this.theCreateBootstrapStore = new KeyStoreCertificateStore(){

                public Collection<X509Certificate> getCertificates(String subjectName) {
                    ++TestPlan.this.getCertificatesCalls;
                    return TestPlan.this.getCertificates_Internal(subjectName);
                }
            };
            return this.theCreateBootstrapStore;
        }

        protected void doAssertions(Collection<X509Certificate> getCertificates) throws Exception {
        }
    }
}

