/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.unit.AbstractServerTest;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.nhindirect.ldap.LDAPResearchTest;
import org.nhindirect.ldap.PrivkeySchema;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapStoreConfiguration;
import org.nhindirect.stagent.cert.impl.provider.LdapCertificateStoreProvider;

public class LdapCertificateStoreTest
extends AbstractServerTest {
    public void setUp() throws Exception {
        MutablePartitionConfiguration pcfg = new MutablePartitionConfiguration();
        pcfg.setName("lookupTest");
        pcfg.setSuffix("cn=lookupTest");
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("objectClass");
        indexedAttrs.add("cn");
        pcfg.setIndexedAttributes(indexedAttrs);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("objectClass");
        attr.add("top");
        attrs.put(attr);
        pcfg.setContextEntry((Attributes)attrs);
        HashSet<MutablePartitionConfiguration> pcfgs = new HashSet<MutablePartitionConfiguration>();
        pcfgs.add(pcfg);
        this.configuration.setContextPartitionConfigurations(pcfgs);
        this.configuration.setWorkingDirectory(new File("LDAP-TEST"));
        Set schemas = this.configuration.getBootstrapSchemas();
        schemas.add(new PrivkeySchema());
        this.configuration.setBootstrapSchemas(schemas);
        super.setUp();
        InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream("ldifs/privCertsOnly.ldif");
        if (stream == null) {
            throw new IOException("Failed to load ldif file");
        }
        this.importLdif(stream);
    }

    protected void addCertificatesToLdap(String[] filename) throws NamingException {
        Entry entry = new Entry();
        entry.addAttribute("objectClass", (Object)"organizationalUnit");
        entry.addAttribute("objectClass", (Object)"top");
        entry.addAttribute("objectClass", (Object)"userPrivKey");
        entry.addAttribute("email", (Object)"gm2552@cerner.com");
        File fl = new File("testfile");
        int idx = fl.getAbsolutePath().lastIndexOf("testfile");
        String path = fl.getAbsolutePath().substring(0, idx);
        for (int i = 0; i < filename.length; ++i) {
            byte[] buffer = new byte[(int)new File(path + "src/test/resources/" + filename[i]).length() + 100];
            try {
                InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream(filename[i]);
                stream.read(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Base64 base64 = new Base64();
            String certificateValue = new String(base64.encode(buffer));
            entry.addAttribute("privKeyStore", (Object)certificateValue);
        }
        entry.addAttribute("ou", (Object)"gm2552");
        this.rootDSE.createSubcontext("ou=gm2552, ou=privKeys, ou=cerner, ou=com, cn=lookupTest", entry.getAttributes());
    }

    public void testLdapSearch_X509Certificate() throws Exception {
        this.addCertificatesToLdap(new String[]{"certs/bob.der"});
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/" + "cn=lookupTest";
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(new String[]{url}, "", "email", "privKeyStore", "X509");
        LdapCertificateStoreProvider provider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, null);
        LDAPCertificateStore certificateResolver = (LDAPCertificateStore)provider.get();
        Collection certs = certificateResolver.getCertificates("gm2552@cerner.com");
        LdapCertificateStoreTest.assertEquals((int)1, (int)certs.size());
        X509Certificate cert = (X509Certificate)certs.iterator().next();
        LdapCertificateStoreTest.assertFalse((boolean)(cert instanceof X509CertificateEx));
        LdapCertificateStoreTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("bob@nhind.hsgincubator.com"));
    }

    public void testLdapSearch_LdapProviderSupportsMultipleURLs() throws Exception {
        this.addCertificatesToLdap(new String[]{"certs/bob.der"});
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/" + "cn=lookupTest";
        String fakeUrl = "ldap://localhost:" + (port += 10) + "/" + "cn=lookupTest";
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(new String[]{fakeUrl, url}, "", "email", "privKeyStore", "X509");
        LdapCertificateStoreProvider provider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, null);
        LDAPCertificateStore certificateResolver = (LDAPCertificateStore)provider.get();
        Collection certs = certificateResolver.getCertificates("gm2552@cerner.com");
        LdapCertificateStoreTest.assertEquals((int)1, (int)certs.size());
        X509Certificate cert = (X509Certificate)certs.iterator().next();
        LdapCertificateStoreTest.assertFalse((boolean)(cert instanceof X509CertificateEx));
        LdapCertificateStoreTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("bob@nhind.hsgincubator.com"));
    }

    public void testLdapSearch_MultipleX509Certificates() throws Exception {
        this.addCertificatesToLdap(new String[]{"certs/bob.der", "certs/cacert.der"});
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/" + "cn=lookupTest";
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(new String[]{url}, "", "email", "privKeyStore", "X509");
        LdapCertificateStoreProvider provider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, null);
        LDAPCertificateStore certificateResolver = (LDAPCertificateStore)provider.get();
        Collection certs = certificateResolver.getCertificates("gm2552@cerner.com");
        LdapCertificateStoreTest.assertEquals((int)2, (int)certs.size());
        Iterator iterator = certs.iterator();
        X509Certificate cert = (X509Certificate)iterator.next();
        LdapCertificateStoreTest.assertFalse((boolean)(cert instanceof X509CertificateEx));
        LdapCertificateStoreTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("bob@nhind.hsgincubator.com"));
        cert = (X509Certificate)iterator.next();
        LdapCertificateStoreTest.assertFalse((boolean)(cert instanceof X509CertificateEx));
        LdapCertificateStoreTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("gmeyer@cerner.com"));
    }

    public void testLdapSearch_PKCS12PrivateKey() throws Exception {
        this.addCertificatesToLdap(new String[]{"certs/gm2552encrypted.p12"});
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/" + "cn=lookupTest";
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(new String[]{url}, "", "email", "privKeyStore", "PKCS12");
        ldapStoreConfiguration.setLdapCertPassphrase("1kingpuff");
        LdapCertificateStoreProvider provider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, null);
        LDAPCertificateStore certificateResolver = (LDAPCertificateStore)provider.get();
        Collection certs = certificateResolver.getCertificates("gm2552@cerner.com");
        LdapCertificateStoreTest.assertEquals((int)1, (int)certs.size());
        X509Certificate cert = (X509Certificate)certs.iterator().next();
        LdapCertificateStoreTest.assertTrue((boolean)(cert instanceof X509CertificateEx));
        LdapCertificateStoreTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("gm2552@securehealthemail.com"));
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }
}

