/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import junit.framework.Assert;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.unit.AbstractServerTest;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.mockito.Mockito;
import org.nhindirect.stagent.cert.impl.LdapPublicCertUtilImpl;
import org.nhindirect.stagent.cert.impl.util.Lookup;
import org.nhindirect.stagent.cert.impl.util.LookupFactory;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.TestUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.SRVRecord;

public class LDAPPublicCertUtil_ldapSearch_Test
extends AbstractServerTest {
    private Lookup mockLookup;

    public void setUp() throws Exception {
        MutablePartitionConfiguration pcfg = new MutablePartitionConfiguration();
        pcfg.setName("lookupTestPublic");
        pcfg.setSuffix("cn=lookupTestPublic");
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("objectClass");
        indexedAttrs.add("cn");
        pcfg.setIndexedAttributes(indexedAttrs);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("objectClass");
        attr.add("top");
        attrs.put(attr);
        pcfg.setContextEntry((Attributes)attrs);
        HashSet<MutablePartitionConfiguration> pcfgs = new HashSet<MutablePartitionConfiguration>();
        pcfgs.add(pcfg);
        this.configuration.setContextPartitionConfigurations(pcfgs);
        this.configuration.setWorkingDirectory(new File("LDAP-TEST"));
        Set schemas = this.configuration.getBootstrapSchemas();
        this.configuration.setBootstrapSchemas(schemas);
        this.mockLookup = (Lookup)Mockito.mock(Lookup.class);
        LookupFactory.getFactory().addOverrideImplementation(this.mockLookup);
        super.setUp();
    }

    public void tearDown() throws Exception {
        LookupFactory.getFactory().removeOverrideImplementation();
        super.tearDown();
    }

    public void testLDAPSearch_getSingleCert_assertCertFound() throws Exception {
        new TestPlan(){
            X509Certificate checkCert = TestUtils.loadCertificate("gm2552.der");

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "gm2552@cerner.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertEquals((Object)this.checkCert, (Object)certs.iterator().next());
            }
        }.perform();
    }

    public void testLDAPSearch_getSingleCertByDomain_assertCertFound() throws Exception {
        new TestPlan(){
            X509Certificate checkCert = TestUtils.loadCertificate("gm2552.der");

            @Override
            protected void createLdapEntries() throws Exception {
                Entry entry = new Entry();
                entry.addAttribute("objectClass", (Object)"organizationalUnit");
                entry.addAttribute("objectClass", (Object)"top");
                entry.addAttribute("objectClass", (Object)"iNetOrgPerson");
                entry.addAttribute("mail", (Object)"cerner.com");
                X509Certificate cert = TestUtils.loadCertificate("gm2552.der");
                entry.addAttribute("userCertificate", (Object)cert.getEncoded());
                entry.addAttribute("ou", (Object)"gm2552");
                entry.addAttribute("cn", (Object)"Greg Meyer");
                entry.addAttribute("sn", (Object)"");
                LDAPPublicCertUtil_ldapSearch_Test.this.rootDSE.createSubcontext("ou=gm2552, cn=lookupTestPublic", entry.getAttributes());
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "cerner.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertEquals((Object)this.checkCert, (Object)certs.iterator().next());
            }
        }.perform();
    }

    public void testLDAPSearch_getMultipleCertsByDomain_assertCertsFound() throws Exception {
        new TestPlan(){
            X509Certificate check1Cert = TestUtils.loadCertificate("gm2552.der");
            X509Certificate check2Cert = TestUtils.loadCertificate("ryan.der");

            @Override
            protected void createLdapEntries() throws Exception {
                Entry entry = new Entry();
                entry.addAttribute("objectClass", (Object)"organizationalUnit");
                entry.addAttribute("objectClass", (Object)"top");
                entry.addAttribute("objectClass", (Object)"iNetOrgPerson");
                entry.addAttribute("mail", (Object)"cerner.com");
                entry.addAttribute("userCertificate", (Object)this.check1Cert.getEncoded());
                entry.putAttribute("userCertificate", (Object)this.check2Cert.getEncoded());
                entry.addAttribute("ou", (Object)"gm2552");
                entry.addAttribute("cn", (Object)"Greg Meyer");
                entry.addAttribute("sn", (Object)"");
                LDAPPublicCertUtil_ldapSearch_Test.this.rootDSE.createSubcontext("ou=gm2552, cn=lookupTestPublic", entry.getAttributes());
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "cerner.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)2, (int)certs.size());
                Iterator<X509Certificate> iter = certs.iterator();
                Assert.assertEquals((Object)this.check1Cert, (Object)iter.next());
                Assert.assertEquals((Object)this.check2Cert, (Object)iter.next());
            }
        }.perform();
    }

    public void testLDAPSearch_getSingleCert_assertCertNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "dummy.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)0, (int)certs.size());
            }
        }.perform();
    }

    public void testLDAPSearch_getSingleCert_noSRVRecords_assertCertNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected SRVRecord[] getSRVRecords() throws Exception {
                return null;
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "dummy.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)0, (int)certs.size());
            }
        }.perform();
    }

    public void testLDAPSearch_getSingleCert_noBaseDNs_assertCertNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected void performInner() throws Exception {
                String subjectToSearch = this.getSubjectToSearch();
                LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl(){

                    protected List<String> getBaseNamingContexts(InitialDirContext ctx) {
                        return Collections.emptyList();
                    }
                };
                Collection certs = impl.ldapSearch(subjectToSearch);
                this.doAssertions(certs);
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "dummy.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)0, (int)certs.size());
            }
        }.perform();
    }

    public void testLDAPSearch_getSingleCert_multipleSRVRecords_assertCertFound() throws Exception {
        new TestPlan(){
            X509Certificate checkCert = TestUtils.loadCertificate("gm2552.der");

            @Override
            protected SRVRecord[] getSRVRecords() throws Exception {
                SRVRecord srvRecord1 = new SRVRecord(new Name("_ldap._tcp.example.com."), 1, 3600L, 0, 1, LDAPPublicCertUtil_ldapSearch_Test.this.port - 1, new Name("localhost."));
                SRVRecord srvRecord2 = new SRVRecord(new Name("_ldap._tcp.example.com."), 1, 3600L, 0, 1, LDAPPublicCertUtil_ldapSearch_Test.this.port, new Name("localhost."));
                return new SRVRecord[]{srvRecord1, srvRecord2};
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "gm2552@cerner.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertEquals((Object)this.checkCert, (Object)certs.iterator().next());
            }
        }.perform();
    }

    public void testLDAPSearch_exceptionInSearch_assertExeption() throws Exception {
        new TestPlan(){
            X509Certificate checkCert = TestUtils.loadCertificate("gm2552.der");

            @Override
            protected void performInner() throws Exception {
                String subjectToSearch = this.getSubjectToSearch();
                LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl(){

                    protected List<String> getBaseNamingContexts(InitialDirContext ctx) {
                        throw new RuntimeException();
                    }
                };
                Collection certs = impl.ldapSearch(subjectToSearch);
                this.doAssertions(certs);
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "gm2552@cerner.com";
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        TestPlan() {
        }

        @Override
        protected void setupMocks() {
            try {
                this.createLdapEntries();
                SRVRecord[] srvRecords = this.getSRVRecords();
                Mockito.when((Object)LDAPPublicCertUtil_ldapSearch_Test.this.mockLookup.run()).thenReturn((Object)srvRecords);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        protected SRVRecord[] getSRVRecords() throws Exception {
            SRVRecord srvRecord = new SRVRecord(new Name("_ldap._tcp.example.com."), 1, 3600L, 0, 1, LDAPPublicCertUtil_ldapSearch_Test.this.port, new Name("localhost."));
            return new SRVRecord[]{srvRecord};
        }

        @Override
        protected void performInner() throws Exception {
            String subjectToSearch = this.getSubjectToSearch();
            LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl();
            Collection certs = impl.ldapSearch(subjectToSearch);
            this.doAssertions(certs);
        }

        protected void createLdapEntries() throws Exception {
            Entry entry = new Entry();
            entry.addAttribute("objectClass", (Object)"organizationalUnit");
            entry.addAttribute("objectClass", (Object)"top");
            entry.addAttribute("objectClass", (Object)"iNetOrgPerson");
            entry.addAttribute("mail", (Object)"gm2552@cerner.com");
            X509Certificate cert = TestUtils.loadCertificate("gm2552.der");
            entry.addAttribute("userCertificate", (Object)cert.getEncoded());
            entry.addAttribute("ou", (Object)"gm2552");
            entry.addAttribute("cn", (Object)"Greg Meyer");
            entry.addAttribute("sn", (Object)"");
            LDAPPublicCertUtil_ldapSearch_Test.this.rootDSE.createSubcontext("ou=gm2552, cn=lookupTestPublic", entry.getAttributes());
        }

        protected abstract String getSubjectToSearch() throws Exception;

        protected abstract void doAssertions(Collection<X509Certificate> var1) throws Exception;
    }
}

