/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;

public class DefaultNHINDAgent_ProcessIncoming_RawStringAndAddresses_Test
extends TestCase {
    public void testCorrectRecipientsParamIsPassedToCheckEnvelopeAddresses() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
                Assert.assertEquals((Object)this.theCreateRecipients, (Object)recipients);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    public void testCorrectSenderParamIsPassedToCheckEnvelopeAddresses() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
                Assert.assertEquals((Object)this.theCreateSender, (Object)sender);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    public void testProcessIncomingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.processIncomingCalls);
                Assert.assertEquals((Object)this.theProcessIncoming, (Object)processIncoming);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int checkEnvelopeAddressesCalls = 0;
        protected IncomingMessage theProcessIncoming;
        protected int processIncomingCalls = 0;
        protected String theCreateMessageText;
        protected NHINDAddressCollection theCreateRecipients;
        protected NHINDAddress theCreateSender;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            IncomingMessage processIncoming = impl.processIncoming(this.createMessageText(), this.createRecipients(), this.createSender());
            this.doAssertions(processIncoming);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void checkEnvelopeAddresses(NHINDAddressCollection recipients, NHINDAddress sender) {
                    ++TestPlan.this.checkEnvelopeAddressesCalls;
                    TestPlan.this.checkEnvelopeAddresses_Internal(recipients, sender);
                }

                public IncomingMessage processIncoming(IncomingMessage message) {
                    ++TestPlan.this.processIncomingCalls;
                    return TestPlan.this.processIncoming_Internal(message);
                }
            };
        }

        protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
        }

        protected IncomingMessage processIncoming_Internal(IncomingMessage message) {
            this.theProcessIncoming = message;
            return this.theProcessIncoming;
        }

        protected String createMessageText() throws Exception {
            this.theCreateMessageText = "createMessageText";
            return this.theCreateMessageText;
        }

        protected NHINDAddressCollection createRecipients() throws Exception {
            this.theCreateRecipients = new NHINDAddressCollection();
            this.theCreateRecipients.add((Object)new NHINDAddress(""));
            return this.theCreateRecipients;
        }

        protected NHINDAddress createSender() throws Exception {
            this.theCreateSender = new NHINDAddress("");
            return this.theCreateSender;
        }

        protected void doAssertions(IncomingMessage processIncoming) throws Exception {
        }
    }
}

