/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.TrustModel;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class TrustModel_EnforceOutgoingMessage_Test
extends TestCase {
    public void testOutgoingMessageIsNull_ThrowsIllegalArgumentException() throws Exception {
        new TestPlan(){

            @Override
            protected OutgoingMessage createMessage() throws Exception {
                this.theCreateMessage = null;
                return this.theCreateMessage;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateMessage);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testRecipientHasCertificate_SetsTrustEnforcementStatusAsSuccess() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = true;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((Object)TrustEnforcementStatus.Success, (Object)this.recip.getStatus());
            }
        }.perform();
    }

    public void testRecipientDoesNotHaveCertificate_SetsTrustEnforcementStatusAsFailed() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = false;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((Object)TrustEnforcementStatus.Failed, (Object)this.recip.getStatus());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected Collection<X509Certificate> theFindTrustedCerts;
        protected int findTrustedCertsCalls = 0;
        protected OutgoingMessage theCreateMessage;
        protected NHINDAddressCollection theGetRecipients;
        protected int getRecipientsCalls = 0;
        protected NHINDAddress recip;
        protected boolean theHasCertificates;
        protected int hasCertificatesCalls = 0;
        protected NHINDAddress theGetSender;
        protected int getSenderCalls = 0;
        protected Collection<X509Certificate> theGetTrustAnchors;
        protected int getTrustAnchorsCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            TrustModel impl = this.createTrustModel();
            impl.enforce(this.createMessage());
            this.doAssertions();
        }

        protected TrustModel createTrustModel() throws Exception {
            return new TrustModel(){

                protected Collection<X509Certificate> findTrustedCerts(Collection<X509Certificate> certs, Collection<X509Certificate> anchors) {
                    ++TestPlan.this.findTrustedCertsCalls;
                    return TestPlan.this.findTrustedCerts_Internal(certs, anchors);
                }
            };
        }

        protected Collection<X509Certificate> findTrustedCerts_Internal(Collection<X509Certificate> certs, Collection<X509Certificate> anchors) {
            this.theFindTrustedCerts = new ArrayList<X509Certificate>();
            return this.theFindTrustedCerts;
        }

        protected OutgoingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new OutgoingMessage(msg, recipients, sender){

                public NHINDAddressCollection getRecipients() {
                    ++TestPlan.this.getRecipientsCalls;
                    return TestPlan.this.getRecipients_Internal();
                }

                public NHINDAddress getSender() {
                    ++TestPlan.this.getSenderCalls;
                    return TestPlan.this.getSender_Internal();
                }
            };
            return this.theCreateMessage;
        }

        protected NHINDAddressCollection getRecipients_Internal() {
            this.theGetRecipients = new NHINDAddressCollection();
            this.recip = new NHINDAddress(""){

                public boolean hasCertificates() {
                    ++TestPlan.this.hasCertificatesCalls;
                    return TestPlan.this.hasCertificates_Internal();
                }
            };
            this.theGetRecipients.add((Object)this.recip);
            return this.theGetRecipients;
        }

        protected boolean hasCertificates_Internal() {
            this.theHasCertificates = false;
            return this.theHasCertificates;
        }

        protected NHINDAddress getSender_Internal() {
            this.theGetSender = new NHINDAddress(""){

                public Collection<X509Certificate> getTrustAnchors() {
                    ++TestPlan.this.getTrustAnchorsCalls;
                    return TestPlan.this.getTrustAnchors_Internal();
                }
            };
            return this.theGetSender;
        }

        protected Collection<X509Certificate> getTrustAnchors_Internal() {
            this.theGetTrustAnchors = new ArrayList<X509Certificate>();
            return this.theGetTrustAnchors;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

