/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.MutableAgent;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.NHINDAgentEventListener;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.NHINDStandard;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.annotation.AgentDomains;
import org.nhindirect.stagent.annotation.PrivateCerts;
import org.nhindirect.stagent.annotation.PublicCerts;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.mail.MimeStandard;
import org.nhindirect.stagent.mail.WrappedMessage;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.TrustError;
import org.nhindirect.stagent.trust.TrustException;
import org.nhindirect.stagent.trust.TrustModel;

public class DefaultNHINDAgent
implements NHINDAgent,
MutableAgent {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultNHINDAgent.class);
    private static boolean initialConstruct = true;
    static MimeMultipart lastMMPart = null;
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private Cryptographer cryptographer;
    private CertificateResolver privateCertResolver;
    private Collection<CertificateResolver> publicCertResolver;
    private TrustAnchorResolver trustAnchors;
    private TrustModel trustModel;
    private TrustEnforcementStatus minTrustRequirement;
    private Collection<String> domains;
    private NHINDAgentEventListener m_listener = null;
    private boolean encryptionEnabled = true;
    private boolean wrappingEnabled = true;

    public DefaultNHINDAgent(String domain, CertificateResolver privateCerts, CertificateResolver publicCerts, TrustAnchorResolver anchors) {
        this(domain, privateCerts, publicCerts, anchors, TrustModel.Default, (Cryptographer)SMIMECryptographerImpl.Default);
    }

    public DefaultNHINDAgent(Collection<String> domains, CertificateResolver privateCerts, CertificateResolver publicCerts, TrustAnchorResolver anchors) {
        this(domains, privateCerts, publicCerts, anchors, TrustModel.Default, (Cryptographer)SMIMECryptographerImpl.Default);
    }

    public DefaultNHINDAgent(String domain, CertificateResolver privateCerts, CertificateResolver publicCerts, TrustAnchorResolver anchors, TrustModel trustModel, Cryptographer cryptographer) {
        this(Arrays.asList(domain), privateCerts, Arrays.asList(publicCerts), anchors, trustModel, cryptographer);
    }

    @Inject
    public DefaultNHINDAgent(@AgentDomains Collection<String> domains, @PrivateCerts CertificateResolver privateCerts, @PublicCerts Collection<CertificateResolver> publicCerts, TrustAnchorResolver anchors, TrustModel trustModel, Cryptographer cryptographer) {
        if (domains == null || domains.size() == 0 || privateCerts == null || publicCerts == null || anchors == null || trustModel == null || cryptographer == null) {
            throw new IllegalArgumentException();
        }
        if (initialConstruct) {
            StringBuilder domainLogInfo = new StringBuilder("Initializing NHINDAgent\r\nLocal domains:");
            for (String domain : domains) {
                domainLogInfo.append("\r\n\t" + domain);
            }
            LOGGER.info((Object)domainLogInfo);
            initialConstruct = false;
        }
        this.domains = domains;
        this.privateCertResolver = privateCerts;
        this.publicCertResolver = publicCerts;
        this.cryptographer = cryptographer;
        this.trustAnchors = anchors;
        this.trustModel = trustModel;
        this.minTrustRequirement = TrustEnforcementStatus.Success_Offline;
        if (this.trustModel.getCertChainValidator() != null && !this.trustModel.getCertChainValidator().isCertificateResolver()) {
            this.trustModel.getCertChainValidator().setCertificateResolver(this.publicCertResolver);
        }
    }

    public DefaultNHINDAgent(Collection<String> domains, CertificateResolver privateCerts, CertificateResolver publicCerts, TrustAnchorResolver anchors, TrustModel trustModel, Cryptographer cryptographer) {
        this(domains, privateCerts, Arrays.asList(publicCerts), anchors, trustModel, cryptographer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDomains(Collection<String> domains) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.domains = domains;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getDomains() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            Collection<String> collection = Collections.unmodifiableCollection(this.domains);
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cryptographer getCryptographer() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            Cryptographer cryptographer = this.cryptographer;
            return cryptographer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCryptographer(Cryptographer cryptographer) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.cryptographer = cryptographer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEncryptMessages() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            boolean bl = this.encryptionEnabled;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncryptMessages(boolean value) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.encryptionEnabled = value;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrappingEnabled() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            boolean bl = this.wrappingEnabled;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWrappingEnabled(boolean wrappingEnabled) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.wrappingEnabled = wrappingEnabled;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateResolver getPublicCertResolver() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (this.publicCertResolver != null && this.publicCertResolver.size() > 0) {
                CertificateResolver certificateResolver = this.publicCertResolver.iterator().next();
                return certificateResolver;
            }
            CertificateResolver certificateResolver = null;
            return certificateResolver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CertificateResolver> getPublicCertResolvers() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            Collection<CertificateResolver> collection = this.publicCertResolver;
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicCertResolvers(Collection<CertificateResolver> resolvers) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.publicCertResolver = resolvers;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateResolver getPrivateCertResolver() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            CertificateResolver certificateResolver = this.privateCertResolver;
            return certificateResolver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrivateCertResolver(CertificateResolver resolver) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.privateCertResolver = resolver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrustAnchorResolver getTrustAnchors() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            TrustAnchorResolver trustAnchorResolver = this.trustAnchors;
            return trustAnchorResolver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrustAnchorResolver(TrustAnchorResolver resolver) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.trustAnchors = resolver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustEnforcementStatus getMinTrustRequirement() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            TrustEnforcementStatus trustEnforcementStatus = this.minTrustRequirement;
            return trustEnforcementStatus;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinTrustRequirement(TrustEnforcementStatus value) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            if (value.compareTo(TrustEnforcementStatus.Success_Offline) < 0) {
                throw new IllegalArgumentException();
            }
            this.minTrustRequirement = value;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventListener(NHINDAgentEventListener listener) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.m_listener = listener;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NHINDAgentEventListener getEventListener() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            NHINDAgentEventListener nHINDAgentEventListener = this.m_listener;
            return nHINDAgentEventListener;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public IncomingMessage processIncoming(String messageText) {
        if (messageText == null || messageText.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.processIncoming(new IncomingMessage(messageText));
    }

    @Override
    public IncomingMessage processIncoming(String messageText, NHINDAddressCollection recipients, NHINDAddress sender) {
        this.checkEnvelopeAddresses(recipients, sender);
        IncomingMessage message = new IncomingMessage(messageText, recipients, sender);
        return this.processIncoming(message);
    }

    @Override
    public IncomingMessage processIncoming(MessageEnvelope envelope) {
        if (envelope == null) {
            throw new IllegalArgumentException();
        }
        this.checkEnvelopeAddresses(envelope);
        return this.processIncoming(new IncomingMessage(envelope));
    }

    @Override
    public IncomingMessage processIncoming(MimeMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        IncomingMessage inMsg = null;
        try {
            inMsg = new IncomingMessage(new Message(msg));
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        return this.processIncoming(inMsg);
    }

    @Override
    public IncomingMessage processIncoming(IncomingMessage message) {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Processing incoming message:\r\n" + message.toString() + "\r\n"));
            }
            try {
                message.setAgent(this);
                message.validate();
                if (this.m_listener != null) {
                    this.m_listener.preProcessIncoming(message);
                }
                this.processMessage(message);
                if (this.m_listener != null) {
                    this.m_listener.postProcessIncoming(message);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Completed processing incoming message.  Result message:\r\n" + EntitySerializer.Default.serialize((MimePart)message.getMessage()) + "\r\n"));
                }
                IncomingMessage incomingMessage = message;
                return incomingMessage;
            }
            catch (Exception error) {
                LOGGER.error((Object)("Error processing incoming message: " + error.getMessage()), (Throwable)error);
                NHINDException throwError = new NHINDException((Object)error);
                if (this.m_listener != null) {
                    this.m_listener.errorIncoming(message, error);
                }
                throw throwError;
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void processMessage(IncomingMessage message) {
        if (message.getSender() == null) {
            throw new TrustException(TrustError.UntrustedSender);
        }
        message.categorizeRecipients(this.getDomains());
        if (!message.hasDomainRecipients()) {
            throw new AgentException(AgentError.NoTrustedRecipients);
        }
        this.bindAddresses(message);
        this.decryptSignedContent(message);
        message.setMessage(this.unwrapMessage(message.getMessage()));
        this.trustModel.enforce(message);
        if (message.hasDomainRecipients()) {
            message.categorizeRecipients(this.minTrustRequirement);
        }
        if (!message.hasDomainRecipients()) {
            throw new TrustException(TrustError.NoTrustedRecipients);
        }
        message.updateRoutingHeaders();
    }

    protected void bindAddresses(IncomingMessage message) {
        message.getSender().setCertificates(this.resolvePublicCerts(message.getSender(), false));
        for (NHINDAddress recipient : message.getDomainRecipients()) {
            Collection<X509Certificate> privateCerts = this.resolvePrivateCerts(recipient, false);
            if (privateCerts == null || privateCerts.size() == 0) {
                LOGGER.warn((Object)("bindAddresses(IncomingMessage message) - Could not resolve a private certificate for recipient " + recipient.getAddress()));
            }
            recipient.setCertificates(privateCerts);
            Collection<X509Certificate> anchors = this.trustAnchors.getIncomingAnchors().getCertificates(recipient);
            if (anchors == null || anchors.size() == 0) {
                LOGGER.warn((Object)("bindAddresses(IncomingMessage message) - Could not obtain incoming trust anchors for recipient " + recipient.getAddress()));
            }
            recipient.setTrustAnchors(anchors);
        }
    }

    protected void decryptSignedContent(IncomingMessage message) {
        MimeEntity decryptedEntity = this.decryptMessage(message);
        try {
            Header hdr;
            MimeEntity payload;
            CMSSignedData signatures;
            if (SMIMEStandard.isContentEnvelopedSignature(new ContentType(decryptedEntity.getContentType()))) {
                signatures = this.cryptographer.deserializeEnvelopedSignature(decryptedEntity);
                payload = new MimeEntity(new ByteArrayInputStream(signatures.getContentInfo().getEncoded()));
            } else if (SMIMEStandard.isContentMultipartSignature(new ContentType(decryptedEntity.getContentType()))) {
                ByteArrayDataSource dataSource = new ByteArrayDataSource(decryptedEntity.getRawInputStream(), decryptedEntity.getContentType());
                MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
                SignedEntity signedEntity = SignedEntity.load(verifyMM);
                signatures = this.cryptographer.deserializeSignatureEnvelope(signedEntity);
                payload = signedEntity.getContent();
            } else {
                throw new AgentException(AgentError.UnsignedMessage);
            }
            message.setSignature(signatures);
            InternetHeaders headers = new InternetHeaders();
            Enumeration eHeaders = message.getMessage().getAllHeaders();
            while (eHeaders.hasMoreElements()) {
                hdr = (Header)eHeaders.nextElement();
                if (MimeStandard.startsWith(hdr.getName(), "Content-")) continue;
                headers.setHeader(hdr.getName(), hdr.getValue());
            }
            eHeaders = payload.getAllHeaders();
            while (eHeaders.hasMoreElements()) {
                hdr = (Header)eHeaders.nextElement();
                headers.setHeader(hdr.getName(), hdr.getValue());
            }
            Message msg = new Message(headers, payload.getContentAsBytes());
            message.setMessage(msg);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidBody, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MimeException(MimeError.InvalidBody, (Exception)e);
        }
    }

    protected MimeEntity decryptMessage(IncomingMessage message) {
        MimeEntity decryptedEntity = null;
        if (this.encryptionEnabled) {
            for (X509Certificate cert : message.getDomainRecipients().getCertificates()) {
                try {
                    if (!(cert instanceof X509CertificateEx)) continue;
                    X509CertificateEx privCert = (X509CertificateEx)cert;
                    decryptedEntity = this.cryptographer.decrypt(message.getMessage(), privCert);
                    break;
                }
                catch (Exception e) {
                }
            }
        } else {
            try {
                decryptedEntity = new MimeEntity(message.getMessage().getRawInputStream());
            }
            catch (MessagingException ex) {
                throw new AgentException(AgentError.MissingMessage);
            }
        }
        if (decryptedEntity == null) {
            throw new AgentException(AgentError.UntrustedMessage);
        }
        return decryptedEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingMessage processOutgoing(String messageText) {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (messageText == null || messageText.length() == 0) {
                throw new IllegalArgumentException();
            }
            OutgoingMessage message = new OutgoingMessage(this.wrapMessage(messageText));
            OutgoingMessage outgoingMessage = this.processOutgoing(message);
            return outgoingMessage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingMessage processOutgoing(String messageText, NHINDAddressCollection recipients, NHINDAddress sender) {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            this.checkEnvelopeAddresses(recipients, sender);
            OutgoingMessage message = new OutgoingMessage(this.wrapMessage(messageText), recipients, sender);
            OutgoingMessage outgoingMessage = this.processOutgoing(message);
            return outgoingMessage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingMessage processOutgoing(MessageEnvelope envelope) {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (envelope == null) {
                throw new IllegalArgumentException();
            }
            this.checkEnvelopeAddresses(envelope);
            OutgoingMessage message = new OutgoingMessage(envelope);
            OutgoingMessage outgoingMessage = this.processOutgoing(message);
            return outgoingMessage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingMessage processOutgoing(OutgoingMessage message) {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            message.setAgent(this);
            message.validate();
            try {
                if (this.m_listener != null) {
                    this.m_listener.preProcessOutgoing(message);
                }
                this.processMessage(message);
                if (this.m_listener != null) {
                    this.m_listener.postProcessOutgoing(message);
                }
            }
            catch (Exception error) {
                LOGGER.error((Object)("Error processing outgoing message: " + error.getMessage()), (Throwable)error);
                NHINDException throwError = new NHINDException((Object)error);
                if (this.m_listener != null) {
                    this.m_listener.errorOutgoing(message, error);
                }
                throw throwError;
            }
            OutgoingMessage outgoingMessage = message;
            return outgoingMessage;
        }
        finally {
            lock.unlock();
        }
    }

    protected void processMessage(OutgoingMessage message) {
        if (!WrappedMessage.isWrapped(message.getMessage())) {
            message.setMessage(this.wrapMessage(message.getMessage()));
        }
        if (message.getSender() == null) {
            throw new AgentException(AgentError.MissingFrom);
        }
        this.bindAddresses(message);
        if (!message.hasRecipients()) {
            throw new AgentException(AgentError.MissingTo);
        }
        message.categorizeRecipients(this.getDomains());
        this.trustModel.enforce(message);
        message.categorizeRecipients(this.minTrustRequirement);
        if (!message.hasRecipients()) {
            throw new AgentException(AgentError.NoTrustedRecipients);
        }
        this.signAndEncryptMessage(message);
        message.updateRoutingHeaders();
    }

    protected void bindAddresses(OutgoingMessage message) {
        Collection<X509Certificate> privateCerts = this.resolvePrivateCerts(message.getSender(), true);
        if (privateCerts == null || privateCerts.size() == 0) {
            LOGGER.warn((Object)("bindAddresses(OutgoingMessage message) - Could not resolve a private certificate for sender " + message.getSender().getAddress()));
        }
        message.getSender().setCertificates(privateCerts);
        Collection<X509Certificate> anchors = this.trustAnchors.getOutgoingAnchors().getCertificates(message.getSender());
        if (anchors == null || anchors.size() == 0) {
            LOGGER.warn((Object)("bindAddresses(OutgoingMessage message) - Could not obtain outgoing trust anchors for sender " + message.getSender().getAddress()));
        }
        message.getSender().setTrustAnchors(anchors);
        for (NHINDAddress recipient : message.getRecipients()) {
            Collection<X509Certificate> publicCerts = this.resolvePublicCerts(recipient, false);
            if (publicCerts == null || publicCerts.size() == 0) {
                LOGGER.warn((Object)("bindAddresses(OutgoingMessage message) - Could not resolve a public certificate for recipient " + recipient.getAddress()));
            }
            recipient.setCertificates(publicCerts);
        }
    }

    protected Message wrapMessage(String messageText) {
        Message retVal = null;
        try {
            if (!this.wrappingEnabled) {
                return new Message(EntitySerializer.Default.deserialize(messageText));
            }
            retVal = WrappedMessage.create(messageText, NHINDStandard.MailHeadersUsed);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        return retVal;
    }

    protected Message wrapMessage(Message message) {
        Message retVal = null;
        try {
            if (!this.wrappingEnabled) {
                return message;
            }
            if (WrappedMessage.isWrapped(message)) {
                return message;
            }
            retVal = WrappedMessage.create(message, NHINDStandard.MailHeadersUsed);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        return retVal;
    }

    protected Message unwrapMessage(Message message) {
        if (!this.wrappingEnabled) {
            return message;
        }
        Message retMessage = null;
        try {
            if (!WrappedMessage.isWrapped(message)) {
                return message;
            }
            retMessage = WrappedMessage.extract(message);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        return retMessage;
    }

    protected void signAndEncryptMessage(OutgoingMessage message) {
        SignedEntity signedEntity = this.cryptographer.sign(message.getMessage(), message.getSender().getCertificates());
        try {
            if (this.encryptionEnabled) {
                Header hdr;
                MimeEntity encryptedEntity = this.cryptographer.encrypt(signedEntity.getMimeMultipart(), message.getRecipients().getCertificates());
                InternetHeaders headers = new InternetHeaders();
                Enumeration eHeaders = message.getMessage().getAllHeaders();
                while (eHeaders.hasMoreElements()) {
                    hdr = (Header)eHeaders.nextElement();
                    headers.setHeader(hdr.getName(), hdr.getValue());
                }
                eHeaders = encryptedEntity.getAllHeaders();
                while (eHeaders.hasMoreElements()) {
                    hdr = (Header)eHeaders.nextElement();
                    headers.setHeader(hdr.getName(), hdr.getValue());
                }
                Message msg = new Message(headers, encryptedEntity.getContentAsBytes());
                message.setMessage(msg);
            } else {
                InternetHeaders headers = new InternetHeaders();
                Enumeration eHeaders = message.getMessage().getAllHeaders();
                while (eHeaders.hasMoreElements()) {
                    Header hdr = (Header)eHeaders.nextElement();
                    headers.setHeader(hdr.getName(), hdr.getValue());
                }
                headers.setHeader("Content-Type", signedEntity.getMimeMultipart().getContentType());
                Message msg = new Message(headers, signedEntity.getEntityBodyAsBytes());
                message.setMessage(msg);
            }
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidMimeEntity, e);
        }
    }

    private Collection<X509Certificate> resolvePrivateCerts(InternetAddress address, boolean required) {
        Collection<X509Certificate> certs;
        block3: {
            certs = null;
            try {
                certs = this.privateCertResolver.getCertificates(address);
                if (certs == null && required) {
                    throw new AgentException(AgentError.UntrustedSender);
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Exception thrown resolving private certs for address " + address.getAddress()), (Throwable)ex);
                if (!required) break block3;
                throw new NHINDException((Object)ex);
            }
        }
        return certs;
    }

    private Collection<X509Certificate> resolvePublicCerts(InternetAddress address, boolean required) throws NHINDException {
        Collection<X509Certificate> certs;
        block4: {
            certs = null;
            try {
                CertificateResolver publicResolver;
                Iterator<CertificateResolver> i$ = this.publicCertResolver.iterator();
                while (i$.hasNext() && (certs = (publicResolver = i$.next()).getCertificates(address)) == null) {
                }
                if (certs == null && required) {
                    throw new AgentException(AgentError.UnknownRecipient);
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Exception thrown resolving public certs for address " + address.getAddress()), (Throwable)ex);
                if (!required) break block4;
                throw new NHINDException((Object)ex);
            }
        }
        return certs;
    }

    protected void checkEnvelopeAddresses(MessageEnvelope envelope) {
        this.checkEnvelopeAddresses(envelope.getRecipients(), envelope.getSender());
    }

    protected void checkEnvelopeAddresses(NHINDAddressCollection recipients, NHINDAddress sender) {
        if (recipients == null || recipients.size() == 0) {
            throw new AgentException(AgentError.NoRecipients);
        }
        if (sender == null) {
            throw new AgentException(AgentError.NoSender);
        }
        recipients.setSource(AddressSource.RcptTo);
        sender.setSource(AddressSource.MailFrom);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

