/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.X509Store;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;

public abstract class CertificateStore
implements X509Store,
CertificateResolver {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(CertificateStore.class);

    @Override
    public abstract boolean contains(X509Certificate var1);

    @Override
    public abstract void add(X509Certificate var1);

    @Override
    public abstract void remove(X509Certificate var1);

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
        Collection<X509Certificate> certs = this.getAllCertificates();
        if (certs == null) {
            return retVal;
        }
        for (X509Certificate cert : certs) {
            if (!CryptoExtensions.certSubjectContainsName(cert, subjectName)) continue;
            retVal.add(cert);
        }
        return retVal;
    }

    @Override
    public void add(Collection<X509Certificate> certs) {
        if (certs == null) {
            throw new IllegalArgumentException();
        }
        for (X509Certificate cert : certs) {
            this.add(cert);
        }
    }

    @Override
    public void remove(Collection<X509Certificate> certs) {
        if (certs == null) {
            throw new IllegalArgumentException();
        }
        for (X509Certificate cert : certs) {
            this.remove(cert);
        }
    }

    @Override
    public void remove(String subjectName) {
        Collection<X509Certificate> certs = this.getCertificates(subjectName);
        if (certs != null && certs.size() > 0) {
            this.remove(certs);
        }
    }

    @Override
    public void update(X509Certificate cert) {
        try {
            if (this.contains(cert)) {
                this.remove(cert);
            }
            this.add(cert);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception attempting to update cert in certificate store: " + e.getMessage()));
        }
    }

    @Override
    public void update(Collection<X509Certificate> certs) {
        if (certs == null) {
            throw new IllegalArgumentException();
        }
        for (X509Certificate cert : certs) {
            this.update(cert);
        }
    }

    @Override
    public abstract Collection<X509Certificate> getAllCertificates();

    @Override
    public Collection<X509Certificate> getCertificates(InternetAddress address) {
        return this.getUsableCerts(address);
    }

    private Collection<X509Certificate> getUsableCerts(InternetAddress address) {
        Collection<X509Certificate> certs;
        if (address == null) {
            throw new IllegalArgumentException();
        }
        int index = 0;
        String theAddress = address.getAddress();
        index = theAddress.indexOf("<");
        if (index > -1 && theAddress.endsWith(">")) {
            theAddress = theAddress.substring(index + 1);
            theAddress = theAddress.substring(0, theAddress.length() - 1);
        }
        if (theAddress.indexOf("+") > -1 && theAddress.indexOf("@") > -1) {
            int startIndex = theAddress.indexOf("+");
            int endIndex = theAddress.indexOf("@");
            theAddress = theAddress.substring(0, startIndex) + theAddress.substring(endIndex);
        }
        if ((certs = this.getCertificates("EMAILADDRESS=" + theAddress)) == null || certs.size() == 0) {
            index = theAddress.indexOf("@");
            if (index > -1) {
                theAddress = theAddress.substring(index + 1);
                certs = this.getCertificates("EMAILADDRESS=" + theAddress);
            } else {
                return null;
            }
        }
        return this.filterUsable(certs);
    }

    private Collection<X509Certificate> filterUsable(Collection<X509Certificate> certs) {
        ArrayList<X509Certificate> filteredCerts = new ArrayList<X509Certificate>();
        for (X509Certificate cert : certs) {
            try {
                cert.checkValidity(new GregorianCalendar().getTime());
                CRLRevocationManager revocationManager = CRLRevocationManager.getInstance();
                if (revocationManager.isRevoked(cert)) continue;
                filteredCerts.add(cert);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("filterUsable(Collection<X509Certificate> certs) - Certificate with DN " + cert.getSubjectDN() + " is not valid."), (Throwable)e);
            }
        }
        return filteredCerts.size() == 0 ? null : filteredCerts;
    }
}

