/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.RevocationManager;

public class CRLRevocationManager
implements RevocationManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultNHINDAgent.class);
    private static final int CRL_FETCH_TIMEOUT = 3000;
    private Set<CRL> crlCollection = new HashSet<CRL>();
    private static CertificateFactory certificateFactory;
    private static Map<String, X509CRL> cache;
    protected static final CRLRevocationManager INSTANCE;

    public static CRLRevocationManager getInstance() {
        return INSTANCE;
    }

    public synchronized Set<CRL> getCRLCollection() {
        return Collections.unmodifiableSet(this.crlCollection);
    }

    private void loadCRLs(X509Certificate certificate) {
        block6: {
            if (certificate == null) {
                return;
            }
            try {
                CRLDistPoint distPoints = CRLDistPoint.getInstance((Object)CRLRevocationManager.getExtensionValue(certificate, X509Extensions.CRLDistributionPoints.getId()));
                if (distPoints != null) {
                    for (DistributionPoint distPoint : distPoints.getDistributionPoints()) {
                        X509CRL crlImpl;
                        String distPointURL = distPoint.getDistributionPoint().getName().toString();
                        if (distPointURL.startsWith("General")) {
                            distPointURL = this.getNameString(distPointURL);
                        }
                        if ((crlImpl = this.getCrlFromUri(distPointURL)) == null) continue;
                        this.crlCollection.add(crlImpl);
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn((Object)("Unable to handle CDP CRL(s): " + e.getMessage()));
            }
        }
    }

    @Override
    public synchronized boolean isRevoked(X509Certificate certificate) {
        this.loadCRLs(certificate);
        for (CRL crl : this.getCRLCollection()) {
            if (!crl.isRevoked(certificate)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL getCrlFromUri(String crlUrlString) {
        if (crlUrlString == null || crlUrlString.trim().length() == 0) {
            return null;
        }
        Map<String, X509CRL> map = cache;
        synchronized (map) {
            X509CRL crlImpl;
            block12: {
                crlImpl = cache.get(crlUrlString);
                if (crlImpl != null && crlImpl.getNextUpdate().before(new Date())) {
                    cache.remove(crlUrlString);
                    crlImpl = null;
                }
                if (crlImpl == null) {
                    try {
                        URLConnection urlConnection = new URL(crlUrlString).openConnection();
                        urlConnection.setConnectTimeout(3000);
                        InputStream crlInputStream = urlConnection.getInputStream();
                        try {
                            crlImpl = (X509CRL)certificateFactory.generateCRL(crlInputStream);
                        }
                        finally {
                            crlInputStream.close();
                        }
                        cache.put(crlUrlString, crlImpl);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block12;
                        LOGGER.warn((Object)("Unable to retrieve or parse CRL " + crlUrlString));
                    }
                }
            }
            return crlImpl;
        }
    }

    protected String getNameString(String generalNameString) {
        int index = (generalNameString = generalNameString.trim()).indexOf("http");
        if (index > -1) {
            generalNameString = generalNameString.substring(index);
        }
        return generalNameString;
    }

    protected static DERObject getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CRLRevocationManager.getObject(oid, bytes);
    }

    private static DERObject getObject(String oid, byte[] ext) throws AnnotatedException {
        try {
            ASN1InputStream aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            aIn = new ASN1InputStream(octs.getOctets());
            return aIn.readObject();
        }
        catch (Exception e) {
            throw new NHINDException("exception processing extension " + oid, e);
        }
    }

    public static boolean isCRLDispPointDefined(X509Certificate cert) {
        boolean retVal = false;
        try {
            CRLDistPoint distPoints = CRLDistPoint.getInstance((Object)CRLRevocationManager.getExtensionValue(cert, X509Extensions.CRLDistributionPoints.getId()));
            if (distPoints != null && distPoints.getDistributionPoints() != null && distPoints.getDistributionPoints().length > 0) {
                retVal = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    static {
        cache = new HashMap<String, X509CRL>();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        INSTANCE = new CRLRevocationManager();
    }
}

