/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import com.google.inject.Inject;
import java.io.File;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.annotation.DNSCertStoreBootstrap;
import org.nhindirect.stagent.cert.impl.annotation.DNSCertStoreCachePolicy;
import org.nhindirect.stagent.cert.impl.annotation.DNSCertStoreServers;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.security.CERTConverter;

public class DNSCertificateStore
extends CertificateStore
implements CacheableCertStore {
    private static final String CACHE_NAME = "DNS_REMOTE_CERT_CACHE";
    private CertificateStore localStoreDelegate;
    private List<String> servers = new ArrayList<String>();
    private JCS cache;
    private CertStoreCachePolicy cachePolicy;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DNSCertificateStore.class);

    public DNSCertificateStore() {
        this.setServers(null);
        this.localStoreDelegate = this.createDefaultLocalStore();
        this.loadBootStrap();
    }

    public DNSCertificateStore(Collection<String> servers) {
        this.setServers(servers);
        this.localStoreDelegate = this.createDefaultLocalStore();
        this.loadBootStrap();
    }

    @Inject
    public DNSCertificateStore(@DNSCertStoreServers Collection<String> servers, @DNSCertStoreBootstrap CertificateStore bootstrapStore, @DNSCertStoreCachePolicy CertStoreCachePolicy policy) {
        if (bootstrapStore == null) {
            throw new IllegalArgumentException();
        }
        this.setServers(servers);
        this.cachePolicy = policy;
        this.localStoreDelegate = bootstrapStore;
        this.loadBootStrap();
    }

    private synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = CertCacheFactory.getInstance().getCertCache(CACHE_NAME, this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
            if (this.cachePolicy == null) {
                this.cachePolicy = this.getDefaultPolicy();
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultDNSCachePolicy();
    }

    private CertificateStore createDefaultLocalStore() {
        KeyStoreCertificateStore retVal = new KeyStoreCertificateStore(new File("DNSNHINKeyStore"), "nH!NdK3yStor3", "31visl!v3s");
        return retVal;
    }

    public void setServers(Collection<String> servers) {
        if (servers == null || servers.size() == 0) {
            String[] configedServers = ResolverConfig.getCurrentConfig().servers();
            if (configedServers != null) {
                this.servers.addAll(Arrays.asList(configedServers));
            }
        } else {
            this.servers.clear();
            this.servers.addAll(servers);
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        return this.localStoreDelegate == null ? false : this.localStoreDelegate.contains(cert);
    }

    @Override
    public void add(X509Certificate cert) {
        if (this.localStoreDelegate != null) {
            this.localStoreDelegate.add(cert);
        }
    }

    @Override
    public void remove(X509Certificate cert) {
        if (this.localStoreDelegate != null) {
            this.localStoreDelegate.remove(cert);
        }
    }

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection<X509Certificate> retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection<X509Certificate>)cache.get((Object)realSubjectName);
            if (!(retVal != null && retVal.size() != 0 || (retVal = this.lookupDNS(realSubjectName)) != null && retVal.size() != 0)) {
                LOGGER.info((Object)("getCertificates(String subjectName) - Could not find a DNS certificate for subject " + subjectName));
            }
        } else {
            retVal = this.lookupDNS(realSubjectName);
            if (retVal.size() == 0 && this.localStoreDelegate != null && ((retVal = this.localStoreDelegate.getCertificates(realSubjectName)) == null || retVal.size() == 0)) {
                LOGGER.info((Object)("getCertificates(String subjectName) - Could not find a DNS certificate for subject " + subjectName));
            }
        }
        return retVal;
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        return this.localStoreDelegate == null ? null : this.localStoreDelegate.getAllCertificates();
    }

    /*
     * WARNING - void declaration
     */
    private Collection<X509Certificate> lookupDNS(String name) {
        String lookupName = name.replace('@', '.');
        Collection<Object> retVal = new ArrayList();
        int index = name.indexOf("@");
        String domain = index > -1 ? name.substring(index + 1) : name;
        try {
            void var7_14;
            Lookup lu = new Lookup(new Name(lookupName), 37);
            lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), 2, 3));
            Record[] recordArray = lu.run();
            if (recordArray == null || recordArray.length == 0) {
                void var7_11;
                Name tempDomain;
                lu = new Lookup(new Name(lookupName), 5);
                lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), 2, 3));
                Record[] recordArray2 = lu.run();
                if (recordArray2 != null && recordArray2.length > 0) {
                    CNAMERecord cnameRect = (CNAMERecord)recordArray2[0];
                    tempDomain = cnameRect.getTarget();
                } else {
                    tempDomain = new Name(domain);
                }
                while (tempDomain.labels() > 1) {
                    lu = new Lookup(tempDomain, 2);
                    lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), 2, 3));
                    Record[] recordArray3 = lu.run();
                    if (recordArray3 != null && recordArray3.length > 0) break;
                    tempDomain = new Name(tempDomain.toString().substring(tempDomain.toString().indexOf(".") + 1));
                }
                if (var7_11 == null || ((void)var7_11).length == 0) {
                    return retVal;
                }
                String[] remoteServers = new String[((void)var7_11).length];
                for (int i = 0; i < remoteServers.length - 0; ++i) {
                    remoteServers[i] = ((NSRecord)var7_11[i]).getTarget().toString();
                }
                lu = new Lookup(new Name(lookupName), 37);
                lu.setResolver((Resolver)this.createExResolver(remoteServers, 2, 3));
                Record[] recordArray4 = lu.run();
            }
            if (var7_14 != null) {
                retVal = new ArrayList();
                for (void rec : var7_14) {
                    Certificate certToAdd;
                    if (!(rec instanceof CERTRecord) || !((certToAdd = CERTConverter.parseRecord((CERTRecord)((CERTRecord)rec))) instanceof X509Certificate)) continue;
                    retVal.add((X509Certificate)certToAdd);
                }
            } else if (domain.length() < name.length()) {
                retVal = this.lookupDNS(domain);
            }
        }
        catch (Exception e) {
            throw new NHINDException((Object)e);
        }
        if (retVal != null && retVal.size() > 0 && this.localStoreDelegate != null) {
            for (X509Certificate x509Certificate : retVal) {
                if (this.localStoreDelegate.contains(x509Certificate)) {
                    this.localStoreDelegate.update(x509Certificate);
                    continue;
                }
                this.localStoreDelegate.add(x509Certificate);
            }
            try {
                if (this.cache != null) {
                    this.cache.put((Object)name, retVal);
                }
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        return retVal;
    }

    @Override
    public void flush(boolean purgeBootStrap) {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            if (purgeBootStrap && this.localStoreDelegate != null) {
                this.localStoreDelegate.remove(this.localStoreDelegate.getAllCertificates());
            }
        }
    }

    @Override
    public void loadBootStrap() {
        if (this.localStoreDelegate == null) {
            throw new IllegalStateException("The boot strap store has not been set.");
        }
        JCS cache = null;
        cache = this.getCache();
        if (cache != null) {
            HashMap cacheBuilderMap = new HashMap();
            for (X509Certificate x509Certificate : this.localStoreDelegate.getAllCertificates()) {
            }
            for (Map.Entry entry : cacheBuilderMap.entrySet()) {
                try {
                    cache.put(entry.getKey(), entry.getValue());
                }
                catch (CacheException e) {}
            }
        }
    }

    @Override
    public void loadBootStrap(CertificateStore bootstrapStore) {
        if (this.localStoreDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.localStoreDelegate = bootstrapStore;
        this.loadBootStrap();
    }

    @Override
    public void setBootStrap(CertificateStore bootstrapStore) {
        if (this.localStoreDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.localStoreDelegate = bootstrapStore;
    }

    @Override
    public void setCachePolicy(CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.applyCachePolicy(policy);
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
        ExtendedResolver retVal = null;
        try {
            retVal = new ExtendedResolver(servers);
            retVal.setRetries(retries);
            retVal.setTimeout(timeout);
            retVal.setTCP(true);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return retVal;
    }

    static {
        Cache ch = Lookup.getDefaultCache((int)1);
        ch.clearCache();
    }

    private static class DefaultDNSCachePolicy
    implements CertStoreCachePolicy {
        private DefaultDNSCachePolicy() {
        }

        @Override
        public int getMaxItems() {
            return 1000;
        }

        @Override
        public int getSubjectTTL() {
            return 86400;
        }
    }
}

