/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;

public class StripP12Passphrase {
    private static File p12File;
    private static String filePassPhrase;
    private static String keyPassPhrase;
    private static File createFile;

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.err.println("Invalid number of arguments: can't have 0 arguments.");
            StripP12Passphrase.printUsage();
            System.exit(-1);
        }
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                StripP12Passphrase.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-p12")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: p12 file name.");
                    System.exit(-1);
                }
                p12File = new File(argv[++i]);
                continue;
            }
            if (arg.equals("-filePass")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing p12 file passphrase.");
                    System.exit(-1);
                }
                filePassPhrase = argv[++i];
                continue;
            }
            if (arg.equals("-keyPass")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing private key passphrase.");
                    System.exit(-1);
                }
                keyPassPhrase = argv[++i];
                continue;
            }
            if (arg.equals("-out")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing output file.");
                    System.exit(-1);
                }
                createFile = new File(argv[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                StripP12Passphrase.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            StripP12Passphrase.printUsage();
            System.exit(-1);
        }
        if (StripP12Passphrase.validateParameters()) {
            StripP12Passphrase.stripP12File();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stripP12File() {
        FileOutputStream outStr = null;
        try {
            byte[] p12Data = StripP12Passphrase.loadFileData(p12File);
            if (p12Data != null) {
                X509CertificateEx p12Cert = StripP12Passphrase.certFromData(p12Data);
                if (p12Cert == null) {
                    return;
                }
                File outFile = StripP12Passphrase.getPKCS12OutFile();
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(null, null);
                char[] emptyPass = "".toCharArray();
                localKeyStore.setKeyEntry("privCert", p12Cert.getPrivateKey(), emptyPass, new Certificate[]{p12Cert});
                outStr = new FileOutputStream(outFile);
                localKeyStore.store(outStr, emptyPass);
                System.out.println("Created pcks12 file " + createFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println("Could not create p12 file " + e.getMessage());
        }
        finally {
            if (outStr != null) {
                try {
                    outStr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean validateParameters() {
        if (p12File == null) {
            System.out.println("Missing input p12 file name");
            return false;
        }
        if (!p12File.exists()) {
            System.out.println("P12 file " + p12File.getAbsolutePath() + " does not exist.");
            return false;
        }
        return true;
    }

    private static byte[] loadFileData(File file) throws Exception {
        return FileUtils.readFileToByteArray((File)file);
    }

    private static File getPKCS12OutFile() throws Exception {
        if (createFile == null) {
            String fileName = p12File.getName();
            int index = fileName.lastIndexOf(".");
            if (index > -1) {
                fileName = fileName.substring(0, index);
            }
            fileName = fileName + "_nopass.p12";
            createFile = new File(fileName);
        }
        if (createFile.exists()) {
            createFile.delete();
        }
        createFile.createNewFile();
        return createFile;
    }

    private static X509CertificateEx certFromData(byte[] data) {
        X509CertificateEx retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, filePassPhrase.toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, keyPassPhrase.toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        retVal = X509CertificateEx.fromX509Certificate(cert, (PrivateKey)key);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error decoding p12 input file: " + e.getMessage());
            }
            bais.close();
        }
        catch (Exception e) {
            throw new NHINDException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return retVal;
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java StripP12Passphrase (options)...\n\n");
        use.append("options:\n");
        use.append("-p12        p12 File         P12 formatted file to strip the passphrase from.\n");
        use.append("\n");
        use.append("-filePass   File passphrase  Optional file passphrase protecting the p12 file.\n");
        use.append("            Default: \"\"\n\n");
        use.append("-keyPass    Key passphrase   Optional private key passphrase protecting the internal private key.\n");
        use.append("            Default: \"\"\n\n");
        use.append("-out        Out File         Optional output file name.\n");
        use.append("            Default: <p12 file>_nopass.p12\n\n");
        System.err.println(use);
    }

    static {
        filePassPhrase = "";
        keyPassPhrase = "";
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

