/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools.certgen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import org.nhindirect.stagent.cert.tools.certgen.CertCreateFields;
import org.nhindirect.stagent.cert.tools.certgen.CertGenerator;
import org.nhindirect.stagent.cert.tools.certgen.CertLoader;
import org.nhindirect.stagent.cert.tools.certgen.LeafCertGenDialog;

class CAPanel
extends JPanel {
    static final long serialVersionUID = -92734291206052662L;
    protected static final int WF_CONTEXT_LOAD_CERTS = 0;
    protected static final int WF_CONTEXT_CREATE_CERTS = 1;
    protected static final int WF_CONTEXT_CLEAR = 2;
    protected static final int WF_CONTEXT_CERT_LOADED = 3;
    protected static final int WF_CONTEXT_CERT_CREATED = 4;
    protected JRadioButton createCA;
    protected JRadioButton loadCA;
    protected JTextField certFile;
    protected JTextField certPrivKeyFile;
    protected TextEntryField cnField;
    protected TextEntryField countryField;
    protected TextEntryField stateField;
    protected TextEntryField locField;
    protected TextEntryField orgField;
    protected TextEntryField emailField;
    protected SpinEntryField expField;
    protected DropDownEntry keyStr;
    protected PasswordField passField;
    protected FileField certFileField;
    protected FileField keyFileField;
    protected JButton loadCert;
    protected JButton createCert;
    protected JButton clear;
    protected JButton genCert;
    protected JCheckBox addToAltSubjects;
    protected JCheckBox allowedToSign;
    protected CertCreateFields currentCert;

    public CAPanel() {
        this.initUI();
        this.addActions();
        this.setWorkflowContext(1);
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.createCA = new JRadioButton("Create New CA");
        this.loadCA = new JRadioButton("Load CA");
        ButtonGroup group = new ButtonGroup();
        group.add(this.createCA);
        group.add(this.loadCA);
        this.createCA.setSelected(true);
        JPanel radioPanel = new JPanel(new FlowLayout(0));
        radioPanel.add(this.createCA);
        radioPanel.add(this.loadCA);
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new GridLayout(3, 3, 10, 10));
        this.cnField = new TextEntryField("CN:");
        fieldsPanel.add(this.cnField);
        this.countryField = new TextEntryField("Country:");
        fieldsPanel.add(this.countryField);
        this.stateField = new TextEntryField("State:");
        fieldsPanel.add(this.stateField);
        this.locField = new TextEntryField("Location:");
        fieldsPanel.add(this.locField);
        this.orgField = new TextEntryField("Org:");
        fieldsPanel.add(this.orgField);
        this.emailField = new TextEntryField("Email:");
        fieldsPanel.add(this.emailField);
        this.expField = new SpinEntryField("Experiation (Days):", 365);
        fieldsPanel.add(this.expField);
        this.keyStr = new DropDownEntry("Key Strength:", new Object[]{1024, 2048, 4096});
        fieldsPanel.add(this.keyStr);
        this.passField = new PasswordField("Password:");
        fieldsPanel.add(this.passField);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)radioPanel, "North");
        topPanel.add((Component)fieldsPanel, "Center");
        this.add((Component)topPanel, "North");
        new FlowLayout(0);
        this.certFileField = new FileField("Certificate Authority File:", "");
        this.keyFileField = new FileField("Private Key File:", "");
        JPanel filePanel = new JPanel(new GridLayout(1, 2));
        filePanel.add(this.certFileField);
        filePanel.add(this.keyFileField);
        this.loadCert = new JButton("Load");
        this.loadCert.setVisible(false);
        this.createCert = new JButton("Create");
        this.clear = new JButton("Clear");
        this.clear.setVisible(false);
        this.clear = new JButton("Clear");
        this.genCert = new JButton("Create Leaf Cert");
        this.genCert.setVisible(false);
        this.addToAltSubjects = new JCheckBox("Add Email To Alt Subject Names");
        this.addToAltSubjects.setVisible(true);
        this.allowedToSign = new JCheckBox("Allowed To Sign Certificates");
        this.allowedToSign.setVisible(false);
        JPanel addAltPanel = new JPanel(new FlowLayout(0));
        addAltPanel.add(this.addToAltSubjects);
        addAltPanel.add(this.allowedToSign);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(addAltPanel);
        buttonPanel.add(this.loadCert);
        buttonPanel.add(this.createCert);
        buttonPanel.add(this.clear);
        buttonPanel.add(this.genCert);
        JPanel combineAltAndButtonPanel = new JPanel(new BorderLayout());
        combineAltAndButtonPanel.add((Component)addAltPanel, "West");
        combineAltAndButtonPanel.add((Component)buttonPanel, "East");
        JPanel bottomPannel = new JPanel(new BorderLayout());
        bottomPannel.add((Component)filePanel, "North");
        bottomPannel.add((Component)combineAltAndButtonPanel, "South");
        this.add((Component)bottomPannel, "South");
    }

    private void addActions() {
        this.loadCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.loadCACert();
            }
        });
        this.createCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.createCACert();
            }
        });
        this.createCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.setWorkflowContext(1);
            }
        });
        this.loadCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.setWorkflowContext(0);
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.setWorkflowContext(2);
            }
        });
        this.genCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAPanel.this.createLeaf();
            }
        });
    }

    private void setWorkflowContext(int workflowContext) {
        switch (workflowContext) {
            case 1: 
            case 2: {
                this.cnField.setEnabled(true);
                this.countryField.setEnabled(true);
                this.stateField.setEnabled(true);
                this.locField.setEnabled(true);
                this.orgField.setEnabled(true);
                this.emailField.setEnabled(true);
                this.expField.setEnabled(true);
                this.keyStr.setEnabled(true);
                this.passField.setEnabled(true);
                this.certFileField.setEnabled(true);
                this.keyFileField.setEnabled(true);
                this.createCA.setEnabled(true);
                this.loadCA.setEnabled(true);
                this.loadCert.setVisible(false);
                this.createCert.setVisible(true);
                this.clear.setVisible(false);
                this.genCert.setVisible(false);
                this.addToAltSubjects.setVisible(true);
                if (workflowContext != 2) break;
                this.cnField.setText("");
                this.countryField.setText("");
                this.stateField.setText("");
                this.locField.setText("");
                this.orgField.setText("");
                this.emailField.setText("");
                this.expField.setValue(365);
                this.keyStr.setValue("1024");
                this.passField.clear();
                this.certFileField.setFile(null);
                this.keyFileField.setFile(null);
                this.createCA.setSelected(true);
                this.loadCert.setVisible(false);
                this.createCert.setVisible(true);
                this.clear.setVisible(false);
                this.genCert.setVisible(false);
                this.addToAltSubjects.setVisible(true);
                this.currentCert = null;
                break;
            }
            case 0: {
                this.cnField.setEnabled(false);
                this.countryField.setEnabled(false);
                this.stateField.setEnabled(false);
                this.locField.setEnabled(false);
                this.orgField.setEnabled(false);
                this.emailField.setEnabled(false);
                this.expField.setEnabled(false);
                this.keyStr.setEnabled(false);
                this.passField.setEnabled(true);
                this.loadCert.setVisible(true);
                this.createCert.setVisible(false);
                this.clear.setVisible(false);
                this.genCert.setVisible(false);
                this.addToAltSubjects.setVisible(false);
                this.createCA.setEnabled(true);
                this.loadCA.setEnabled(true);
                this.certFileField.setEnabled(true);
                this.keyFileField.setEnabled(true);
                break;
            }
            case 3: 
            case 4: {
                this.cnField.setEnabled(false);
                this.countryField.setEnabled(false);
                this.stateField.setEnabled(false);
                this.locField.setEnabled(false);
                this.orgField.setEnabled(false);
                this.emailField.setEnabled(false);
                this.expField.setEnabled(false);
                this.keyStr.setEnabled(false);
                this.passField.setEnabled(false);
                this.createCA.setEnabled(false);
                this.loadCA.setEnabled(false);
                this.loadCert.setVisible(false);
                this.createCert.setVisible(false);
                this.clear.setVisible(true);
                this.genCert.setVisible(true);
                this.addToAltSubjects.setVisible(false);
            }
        }
    }

    private void createLeaf() {
        LeafCertGenDialog generator = new LeafCertGenDialog(null, this.currentCert);
        generator.setVisible(true);
    }

    protected File createNewFileName(boolean isKey) {
        int index;
        String field = this.emailField.getText();
        String fileName = !field.isEmpty() ? ((index = field.indexOf("@")) > -1 ? field.substring(0, index) : field) : ((index = (field = this.cnField.getText()).indexOf("@")) > -1 ? field.substring(0, index) : field);
        if (isKey) {
            fileName = fileName + "Key";
        }
        fileName = fileName + ".der";
        return new File(fileName);
    }

    protected void createCACert() {
        CertCreateFields retCert;
        int selection;
        if (this.passField.getPassword().length == 0 && (selection = JOptionPane.showConfirmDialog(this, "The password field is empty.  Do you wish to create a private key file without a password?", "Empty Password", 0, 3)) == 1) {
            return;
        }
        if (this.cnField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Common Name (CN) must have a value.", "Invalid Cert File", 0);
            return;
        }
        if (this.certFileField.getFile().getPath().isEmpty()) {
            this.certFileField.setFile(this.createNewFileName(false));
        }
        if (this.keyFileField.getFile().getPath().isEmpty()) {
            this.keyFileField.setFile(this.createNewFileName(true));
        }
        if ((this.certFileField.getFile().exists() || this.keyFileField.getFile().exists()) && (selection = JOptionPane.showConfirmDialog(this, "The certificate or key file already exists.  This operation will overwrite the file.  Continue?", "Empty Password", 0, 3)) == 1) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("CN", this.cnField.getText());
        if (!this.countryField.getText().isEmpty()) {
            attributes.put("C", this.countryField.getText());
        }
        if (!this.stateField.getText().isEmpty()) {
            attributes.put("ST", this.stateField.getText());
        }
        if (!this.locField.getText().isEmpty()) {
            attributes.put("L", this.locField.getText());
        }
        if (!this.orgField.getText().isEmpty()) {
            attributes.put("O", this.orgField.getText());
        }
        if (!this.emailField.getText().isEmpty()) {
            attributes.put("EMAILADDRESS", this.emailField.getText());
        }
        int exp = Integer.parseInt(this.expField.getValue().toString());
        int keyStre = Integer.parseInt(this.keyStr.getValue().toString());
        CertCreateFields createFields = new CertCreateFields(attributes, this.certFileField.getFile(), this.keyFileField.getFile(), this.passField.getPassword(), exp, keyStre, null, null);
        try {
            retCert = CertGenerator.createCertificate(createFields, this.addToAltSubjects.isSelected());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "An error occured creating the certificate authority: " + e.getMessage(), "Certificate Creation Error", 0);
            return;
        }
        if (retCert == null) {
            JOptionPane.showMessageDialog(this, "An error occured creating the certificate the authority: unknown error", "Certificate Creation Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "CA certificate and private key created successfully.", "SUCCESS", -1);
        this.currentCert = retCert;
        this.setWorkflowContext(4);
    }

    private void loadCACert() {
        CertCreateFields retCert;
        File certFile = this.certFileField.getFile();
        File keyFile = this.keyFileField.getFile();
        if (!certFile.exists()) {
            JOptionPane.showMessageDialog(this, "Certificate file does not exist or cannot be found.", "Invalid Cert File", 0);
            return;
        }
        if (!keyFile.exists()) {
            JOptionPane.showMessageDialog(this, "Private key file does not exist or cannot be found.", "Invalid Key File", 0);
            return;
        }
        try {
            retCert = CertLoader.loadCertificate(certFile, keyFile, this.passField.getPassword());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "An error occured loading the certificate authority: " + e.getMessage(), "Certificate Load Error", 0);
            return;
        }
        if (retCert == null) {
            JOptionPane.showMessageDialog(this, "An error occured loading the certificate the authority: unknown error", "Certificate Creation Error", 0);
            return;
        }
        if (retCert.getSignerCert().getBasicConstraints() < 0 && !retCert.getSignerCert().getSubjectX500Principal().equals(retCert.getSignerCert().getIssuerX500Principal())) {
            JOptionPane.showMessageDialog(this, "This certificate's policy does not allowed it to sign other certificates.", "Policy Validation Error", 0);
            return;
        }
        if (retCert.getAttributes().containsKey("EMAILADDRESS")) {
            this.emailField.setText(retCert.getAttributes().get("EMAILADDRESS").toString());
        } else {
            this.emailField.setText("");
        }
        if (retCert.getAttributes().containsKey("CN")) {
            this.cnField.setText(retCert.getAttributes().get("CN").toString());
        } else {
            this.cnField.setText("");
        }
        if (retCert.getAttributes().containsKey("C")) {
            this.countryField.setText(retCert.getAttributes().get("C").toString());
        } else {
            this.countryField.setText("");
        }
        if (retCert.getAttributes().containsKey("ST")) {
            this.stateField.setText(retCert.getAttributes().get("ST").toString());
        } else {
            this.stateField.setText("");
        }
        if (retCert.getAttributes().containsKey("L")) {
            this.locField.setText(retCert.getAttributes().get("L").toString());
        } else {
            this.locField.setText("");
        }
        if (retCert.getAttributes().containsKey("O")) {
            this.orgField.setText(retCert.getAttributes().get("O").toString());
        } else {
            this.orgField.setText("");
        }
        this.expField.setValue(retCert.getExpDays());
        JOptionPane.showMessageDialog(this, "CA certificate and private key loaded successfully.", "SUCCESS", -1);
        this.currentCert = retCert;
        this.setWorkflowContext(3);
    }

    protected static class FileField
    extends JPanel {
        static final long serialVersionUID = 8783281209944790372L;
        private JLabel label;
        private JTextField text;
        private JButton search;

        public FileField(String labelText, String file) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(labelText);
            this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().getSize().height));
            this.text = new JTextField();
            this.text.setPreferredSize(new Dimension(250, this.label.getPreferredSize().getSize().height));
            this.add((Component)this.label, "North");
            JPanel filePanel = new JPanel(new BorderLayout());
            this.search = new JButton("...");
            this.search.setPreferredSize(new Dimension(30, this.text.getPreferredSize().getSize().height));
            JPanel fileWithSearchPanel = new JPanel(new FlowLayout(0));
            fileWithSearchPanel.add(this.text);
            fileWithSearchPanel.add(this.search);
            filePanel.add((Component)fileWithSearchPanel, "North");
            this.add(filePanel);
            this.search.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileField.this.selectFile();
                }
            });
        }

        private void selectFile() {
            int result;
            File startFile;
            JFileChooser fc = new JFileChooser();
            fc.setDragEnabled(false);
            if (!this.text.getText().trim().isEmpty() && (startFile = new File(this.text.getText())).exists()) {
                fc.setCurrentDirectory(startFile);
            }
            if ((result = fc.showOpenDialog(this)) == 0) {
                this.text.setText(fc.getSelectedFile().getPath());
            }
        }

        public File getFile() {
            return new File(this.text.getText().trim());
        }

        public void setFile(File fl) {
            if (fl != null) {
                this.text.setText(fl.getAbsolutePath());
            } else {
                this.text.setText("");
            }
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.text.setEnabled(b);
            this.search.setEnabled(b);
        }
    }

    protected static class PasswordField
    extends JPanel {
        static final long serialVersionUID = -7837326704224526655L;
        private JLabel label;
        private JPasswordField pass;

        public PasswordField(String labelText) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(labelText);
            this.label.setPreferredSize(new Dimension(150, this.label.getPreferredSize().getSize().height));
            this.pass = new JPasswordField();
            this.pass.setPreferredSize(new Dimension(150, this.label.getPreferredSize().getSize().height));
            this.add((Component)this.label, "North");
            JPanel passPanel = new JPanel(new BorderLayout());
            passPanel.add((Component)this.pass, "North");
            this.add(passPanel);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.pass.setEnabled(b);
        }

        public char[] getPassword() {
            if (this.pass.getPassword() == null || this.pass.getPassword().length == 0) {
                return "".toCharArray();
            }
            return this.pass.getPassword();
        }

        public void clear() {
            this.pass.setText("");
        }
    }

    protected static class DropDownEntry
    extends JPanel {
        static final long serialVersionUID = 3279442634853500454L;
        private JLabel label;
        private JComboBox selections;

        public DropDownEntry(String labelText, Object[] items) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(labelText);
            this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().getSize().height));
            this.selections = new JComboBox<Object>(items);
            this.add((Component)this.label, "North");
            JPanel dropPanel = new JPanel(new BorderLayout());
            dropPanel.add((Component)this.selections, "North");
            this.add(dropPanel);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.selections.setEnabled(b);
        }

        public Object getValue() {
            return this.selections.getSelectedItem();
        }

        public void setValue(Object value) {
            this.selections.setSelectedItem(value);
        }
    }

    protected static class SpinEntryField
    extends JPanel {
        static final long serialVersionUID = 2260694248137330015L;
        private JLabel label;
        private JSpinner value;

        public SpinEntryField(String labelText, int intValue) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(labelText);
            this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().getSize().height));
            this.value = new JSpinner(new SpinnerNumberModel(intValue, -10, 100000, 1));
            this.add((Component)this.label, "North");
            JPanel spinnerPanel = new JPanel(new BorderLayout());
            spinnerPanel.add((Component)this.value, "North");
            this.add(spinnerPanel);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.value.setEnabled(b);
        }

        public Object getValue() {
            return this.value.getValue();
        }

        public void setValue(Object value) {
            this.value.setValue(value);
        }
    }

    protected static class TextEntryField
    extends JPanel {
        static final long serialVersionUID = -7340775331901207365L;
        private JLabel label;
        private JTextField text;

        public TextEntryField(String labelText) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(labelText);
            this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().getSize().height));
            this.text = new JTextField();
            this.text.setPreferredSize(new Dimension(150, this.label.getPreferredSize().getSize().height));
            this.add((Component)this.label, "North");
            JPanel textPanel = new JPanel(new BorderLayout());
            textPanel.add((Component)this.text, "North");
            this.add(textPanel);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.text.setEnabled(b);
        }

        public String getText() {
            return this.text.getText().trim();
        }

        public void setText(String value) {
            this.text.setText(value);
        }
    }
}

