/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.MDNFactory;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;

public class Notification {
    private static Class<?> dsnClass;
    private static Method getHeaders;
    private static final String DefaultExplanation = "Your message was successfully processed.";
    private String explanation = "Your message was successfully processed.";
    private Disposition disposition;
    private ReportingUserAgent reportingAgent;
    private MdnGateway gateway;
    private String originalMsgId;
    private String finalRecipient;
    private String error;
    private MimeMultipartReport report;

    public Notification(NotificationType notification) {
        this(new Disposition(notification));
    }

    public Notification(Disposition disposition) {
        this.disposition = disposition;
        this.originalMsgId = "";
        this.finalRecipient = "";
        this.error = "";
        this.updateReport();
    }

    private void updateReport() {
        try {
            this.report = MDNFactory.create(this.explanation, this.reportingAgent != null ? this.reportingAgent.getName() : "", this.reportingAgent != null ? this.reportingAgent.getProduct() : "", "", this.finalRecipient != null ? this.finalRecipient : "", this.originalMsgId != null ? this.originalMsgId : "", this.error != null ? this.error : "", this.gateway, this.disposition);
            this.report.getBodyPart(1).setHeader("content-type", "message/disposition-notification");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
        this.updateReport();
    }

    public ReportingUserAgent getReportingAgent() {
        return this.reportingAgent;
    }

    public void setReportingAgent(ReportingUserAgent reportingAgent) {
        this.reportingAgent = reportingAgent;
        this.updateReport();
    }

    public MdnGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(MdnGateway gateway) {
        this.gateway = gateway;
        this.updateReport();
    }

    public String getOriginalMessageId() {
        return this.originalMsgId;
    }

    public void setOriginalMessageId(String messageId) {
        this.originalMsgId = messageId;
        this.updateReport();
    }

    public String getFinalRecipeint() {
        return this.finalRecipient;
    }

    public void setFinalRecipient(String recip) {
        this.finalRecipient = recip;
        this.updateReport();
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    public void setDisposition(Disposition disposition) {
        this.disposition = disposition;
        this.updateReport();
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
        this.updateReport();
    }

    public Collection<MimeEntity> getParts() {
        if (this.report == null) {
            this.updateReport();
        }
        ArrayList<MimeEntity> retVal = new ArrayList<MimeEntity>();
        try {
            for (int i = 0; i < this.report.getCount(); ++i) {
                ByteArrayOutputStream oStream = null;
                try {
                    oStream = new ByteArrayOutputStream();
                    this.report.getBodyPart(i).writeTo((OutputStream)oStream);
                    oStream.flush();
                }
                catch (MessagingException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                ByteArrayInputStream str = new ByteArrayInputStream(oStream.toByteArray());
                retVal.add(new MimeEntity(str));
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return retVal;
    }

    public MimeMultipart getAsMultipart() {
        if (this.report == null) {
            this.updateReport();
        }
        return this.report;
    }

    public byte[] serializeToBytes() {
        if (this.report == null) {
            this.updateReport();
        }
        ByteArrayOutputStream oStream = null;
        try {
            oStream = new ByteArrayOutputStream();
            this.report.writeTo((OutputStream)oStream);
            oStream.flush();
        }
        catch (MessagingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return oStream.toByteArray();
    }

    public InputStream getInputStream() {
        if (this.report == null) {
            this.updateReport();
        }
        ByteArrayOutputStream oStream = null;
        try {
            oStream = new ByteArrayOutputStream();
            this.report.writeTo((OutputStream)oStream);
            oStream.flush();
        }
        catch (MessagingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(oStream.toByteArray());
    }

    public String toString() {
        return new String(this.serializeToBytes());
    }

    public InternetHeaders getNotificationFieldsAsHeaders() {
        if (this.report == null) {
            this.updateReport();
        }
        return Notification.getNotificationFieldsAsHeaders((MimeMultipart)this.report);
    }

    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message can not be null");
        }
        MimeMultipart mm = null;
        try {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(message.getRawInputStream(), message.getContentType());
            mm = new MimeMultipart((DataSource)dataSource);
        }
        catch (Exception e) {
            throw new NHINDException("Failed to parse notification fields.", e);
        }
        return Notification.getNotificationFieldsAsHeaders(mm);
    }

    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMultipart mm) {
        InternetHeaders retVal = null;
        if (mm == null) {
            throw new IllegalArgumentException("Multipart can not be null");
        }
        try {
            String[] fields;
            if (mm.getCount() < 2) {
                throw new IllegalArgumentException("Multipart can not be null");
            }
            BodyPart part = mm.getBodyPart(1);
            try {
                Object contecntObj = part.getContent();
                if (dsnClass != null && dsnClass.getCanonicalName().equals(contecntObj.getClass().getCanonicalName())) {
                    retVal = (InternetHeaders)getHeaders.invoke(contecntObj, new Object[0]);
                    return retVal;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!part.getContentType().equalsIgnoreCase("message/disposition-notification")) {
                throw new IllegalArgumentException("Notification part content type is not message/disposition-notification");
            }
            retVal = new InternetHeaders();
            for (String field : fields = Notification.getPartContentBodyAsString(part).split("\r\n")) {
                int idx = field.indexOf(":");
                if (idx <= -1) continue;
                String name = field.substring(0, idx);
                String value = field.substring(idx + 1).trim();
                retVal.setHeader(name, value);
            }
        }
        catch (MessagingException e) {
            throw new NHINDException("Failed to parse notification fields.", (Exception)((Object)e));
        }
        return retVal;
    }

    protected static String getPartContentBodyAsString(BodyPart part) {
        try {
            Object content = part.getContent();
            if (content instanceof String) {
                return content.toString();
            }
            if (content instanceof InputStream) {
                InputStream str = (InputStream)part.getContent();
                byte[] bytes = new byte[str.available()];
                str.read(bytes);
                return new String(bytes);
            }
            return content.toString();
        }
        catch (Exception e) {
            throw new NHINDException("Unable to handle get notification body as a string.", e);
        }
    }

    static {
        try {
            dsnClass = Notification.class.getClassLoader().loadClass("com.sun.mail.dsn.DispositionNotification");
            getHeaders = dsnClass.getMethod("getNotifications", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

