/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.nhindirect.stagent.annotation.PublicCerts;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.utils.InjectionUtils;

public class PublicCertStoreModule
extends AbstractModule {
    private final Collection<Provider<CertificateResolver>> storeProvider;

    public static PublicCertStoreModule create(Provider<CertificateResolver> storeProvider) {
        return new PublicCertStoreModule(Arrays.asList(storeProvider));
    }

    public static PublicCertStoreModule create(Collection<Provider<CertificateResolver>> storeProvider) {
        return new PublicCertStoreModule(storeProvider);
    }

    public PublicCertStoreModule(Collection<Provider<CertificateResolver>> storeProvider) {
        this.storeProvider = storeProvider;
    }

    public PublicCertStoreModule(Provider<CertificateResolver> storeProvider) {
        this(Arrays.asList(storeProvider));
    }

    protected void configure() {
        ArrayList<Object> resolvers = new ArrayList<Object>();
        for (Provider<CertificateResolver> provider : this.storeProvider) {
            resolvers.add(provider.get());
        }
        this.bind(InjectionUtils.collectionOf(CertificateResolver.class)).annotatedWith(PublicCerts.class).toInstance(resolvers);
    }
}

