/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDAgentEventListener;
import org.nhindirect.stagent.NHINDAgentEventListenerAdapter;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessIncoming_Test
extends TestCase {
    public void testNullMessageParam_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected IncomingMessage createMessage() throws Exception {
                this.theCreateMessage = null;
                return this.theCreateMessage;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateMessage);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testAgentIsSetInMessage() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertNotNull((Object)processIncoming.getAgent());
            }
        }.perform();
    }

    public void testMessageIsValidated() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.validateCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToProcessMessageMethod() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void processMessage_Internal(IncomingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.processMessageCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToPreProcessIncomingMethod() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){

            @Override
            protected void preProcessIncoming_Internal(IncomingMessage msg) throws NHINDException {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.preProcessIncomingCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToPostProcessIncomingMethod() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){

            @Override
            protected void postProcessIncoming_Internal(IncomingMessage msg) throws NHINDException {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.postProcessIncomingCalls);
            }
        }.perform();
    }

    public void testPostProcessIncomingMethodThrowsException_ErrorIncomingIsCalled() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){
            protected NHINDException nhindException;

            @Override
            protected void postProcessIncoming_Internal(IncomingMessage msg) throws NHINDException {
                this.nhindException = new NHINDException();
                throw this.nhindException;
            }

            @Override
            protected void errorIncoming_Internal(IncomingMessage msg, Exception e) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
                Assert.assertEquals((Object)this.nhindException, (Object)e);
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertEquals((int)1, (int)this.errorIncomingCalls);
            }
        }.perform();
    }

    class NHINDAgentEventListenerIsNotNull
    extends MessageParamIsNotNull {
        protected int errorIncomingCalls;
        protected int postProcessIncomingCalls;
        protected int preProcessIncomingCalls;

        NHINDAgentEventListenerIsNotNull() {
            this.errorIncomingCalls = 0;
            this.postProcessIncomingCalls = 0;
            this.preProcessIncomingCalls = 0;
        }

        @Override
        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            DefaultNHINDAgent nhindAgent = new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void processMessage(IncomingMessage message) {
                    ++NHINDAgentEventListenerIsNotNull.this.processMessageCalls;
                    NHINDAgentEventListenerIsNotNull.this.processMessage_Internal(message);
                }
            };
            nhindAgent.setEventListener((NHINDAgentEventListener)new NHINDAgentEventListenerAdapter(){

                @Override
                public void errorIncoming(IncomingMessage msg, Exception e) {
                    ++NHINDAgentEventListenerIsNotNull.this.errorIncomingCalls;
                    NHINDAgentEventListenerIsNotNull.this.errorIncoming_Internal(msg, e);
                }

                @Override
                public void postProcessIncoming(IncomingMessage msg) throws NHINDException {
                    ++NHINDAgentEventListenerIsNotNull.this.postProcessIncomingCalls;
                    NHINDAgentEventListenerIsNotNull.this.postProcessIncoming_Internal(msg);
                }

                @Override
                public void preProcessIncoming(IncomingMessage msg) throws NHINDException {
                    ++NHINDAgentEventListenerIsNotNull.this.preProcessIncomingCalls;
                    NHINDAgentEventListenerIsNotNull.this.preProcessIncoming_Internal(msg);
                }
            });
            return nhindAgent;
        }

        protected void errorIncoming_Internal(IncomingMessage msg, Exception e) {
        }

        protected void postProcessIncoming_Internal(IncomingMessage msg) throws NHINDException {
        }

        protected void preProcessIncoming_Internal(IncomingMessage msg) throws NHINDException {
        }
    }

    class MessageParamIsNotNull
    extends TestPlan {
        protected int validateCalls;

        MessageParamIsNotNull() {
            this.validateCalls = 0;
        }

        @Override
        protected IncomingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new IncomingMessage(msg, recipients, sender){

                protected void validate() {
                    ++MessageParamIsNotNull.this.validateCalls;
                    MessageParamIsNotNull.this.validate_Internal();
                }
            };
            return this.theCreateMessage;
        }

        protected void validate_Internal() {
        }
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int processMessageCalls = 0;
        protected IncomingMessage theCreateMessage;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createNHINDAgent();
            IncomingMessage processIncoming = impl.processIncoming(this.createMessage());
            this.doAssertions(processIncoming);
        }

        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void processMessage(IncomingMessage message) {
                    ++TestPlan.this.processMessageCalls;
                    TestPlan.this.processMessage_Internal(message);
                }
            };
        }

        protected void processMessage_Internal(IncomingMessage message) {
        }

        protected IncomingMessage createMessage() throws Exception {
            this.theCreateMessage = new IncomingMessage("");
            return this.theCreateMessage;
        }

        protected void doAssertions(IncomingMessage processIncoming) throws Exception {
        }
    }
}

