/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.utils.TestUtils;

public class CertificateStore_getUsableCertsTest
extends TestCase {
    public void testGetUsableCerts_inValidUserCert_retriveDomainCert() throws Exception {
        final X509CertificateEx userCert = TestUtils.getInternalCert("user1");
        final X509CertificateEx domainCert = TestUtils.getInternalCert("gm2552");
        CertificateStoreAdapter store = new CertificateStoreAdapter(){

            protected Collection<X509Certificate> filterUsable(Collection<X509Certificate> certs) {
                if (certs.iterator().next().getSubjectDN().getName().contains("user1")) {
                    return null;
                }
                return certs;
            }

            public Collection<X509Certificate> getCertificates(String subjectName) {
                if (subjectName.contains("user1@domain.com")) {
                    return Arrays.asList(userCert);
                }
                return Arrays.asList(domainCert);
            }
        };
        Collection foundCert = store.getCertificates(new InternetAddress("user1@domain.com"));
        CertificateStore_getUsableCertsTest.assertEquals((Object)domainCert, foundCert.iterator().next());
    }

    public void testGetUsableCerts_allCertsInvalid_assertNoCerts() throws Exception {
        final X509CertificateEx userCert = TestUtils.getInternalCert("user1");
        final X509CertificateEx domainCert = TestUtils.getInternalCert("gm2552");
        CertificateStoreAdapter store = new CertificateStoreAdapter(){

            protected Collection<X509Certificate> filterUsable(Collection<X509Certificate> certs) {
                return null;
            }

            public Collection<X509Certificate> getCertificates(String subjectName) {
                if (subjectName.contains("user1@domain.com")) {
                    return Arrays.asList(userCert);
                }
                return Arrays.asList(domainCert);
            }
        };
        Collection foundCert = store.getCertificates(new InternetAddress("user1@domain.com"));
        CertificateStore_getUsableCertsTest.assertNull((Object)foundCert);
    }

    public void testGetUsableCerts_getUserCert() throws Exception {
        final X509CertificateEx userCert = TestUtils.getInternalCert("user1");
        final X509CertificateEx domainCert = TestUtils.getInternalCert("gm2552");
        CertificateStoreAdapter store = new CertificateStoreAdapter(){

            protected Collection<X509Certificate> filterUsable(Collection<X509Certificate> certs) {
                if (certs.iterator().next().getSubjectDN().getName().contains("user1")) {
                    return certs;
                }
                return certs;
            }

            public Collection<X509Certificate> getCertificates(String subjectName) {
                if (subjectName.contains("user1@domain.com")) {
                    return Arrays.asList(userCert);
                }
                return Arrays.asList(domainCert);
            }
        };
        Collection foundCert = store.getCertificates(new InternetAddress("user1@domain.com"));
        CertificateStore_getUsableCertsTest.assertEquals((Object)userCert, foundCert.iterator().next());
    }

    static class CertificateStoreAdapter
    extends CertificateStore {
        CertificateStoreAdapter() {
        }

        public boolean contains(X509Certificate cert) {
            return false;
        }

        public void add(X509Certificate cert) {
        }

        public void remove(X509Certificate cert) {
        }

        public Collection<X509Certificate> getAllCertificates() {
            return null;
        }
    }
}

