/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;
import org.nhindirect.stagent.utils.TestUtils;

public class CRLRevocationManager_writeCRLCacheFileTest
extends TestCase {
    public void setUp() {
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    public void testWriteCRLCacheFile_writeToFile() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        CRL crlToWrite = TestUtils.loadCRL("certs.crl");
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_writeCRLCacheFileTest.assertTrue((boolean)crlFile.exists());
    }

    public void testWriteCRLCacheFile_writeToFile_deleteExisting() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        CRL crlToWrite = TestUtils.loadCRL("certs.crl");
        String distURI = "http://localhost:8080/config";
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_writeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        CRLRevocationManager_writeCRLCacheFileTest.assertTrue((boolean)crlFile.exists());
        long originalFileDate = crlFile.lastModified();
        Thread.sleep(2000L);
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_writeCRLCacheFileTest.assertTrue((boolean)crlFile.exists());
        long newFileDate = crlFile.lastModified();
        CRLRevocationManager_writeCRLCacheFileTest.assertTrue((originalFileDate != newFileDate ? 1 : 0) != 0);
    }

    public void testWriteCRLCacheFile_errorInWrite() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        X509CRL crlToWrite = (X509CRL)Mockito.mock(X509CRL.class);
        ((X509CRL)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)crlToWrite)).getEncoded();
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, crlToWrite);
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_writeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
    }

    public void testWriteCRLCacheFile_noCRLLocation_assertFileNotCreated() throws Exception {
        CRL crlToWrite = TestUtils.loadCRL("certs.crl");
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_writeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
    }
}

