/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;
import org.nhindirect.stagent.utils.TestUtils;

public class NotificationTest
extends TestCase {
    public void testCreateNotification_AssertMultipart() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        NotificationTest.assertEquals((String)"Your message was successfully processed.", (String)part.getContent().toString());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        part.writeTo((OutputStream)outStream);
        String content = new String(outStream.toByteArray());
        NotificationTest.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    public void testCreateNotification_AssertGetParts() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        ArrayList entities = (ArrayList)noti.getParts();
        MimeEntity entity = (MimeEntity)entities.get(0);
        NotificationTest.assertEquals((String)"Your message was successfully processed.", (String)entity.getContent().toString());
        entity = (MimeEntity)entities.get(1);
        NotificationTest.assertTrue((boolean)entity.getContentType().startsWith("message/disposition-notification"));
        ByteArrayInputStream str = (ByteArrayInputStream)entity.getContent();
        byte[] bytes = new byte[str.available()];
        str.read(bytes);
        String content = new String(bytes);
        NotificationTest.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    public void testCreateNotification_AssertDispatched() throws Exception {
        Notification noti = new Notification(NotificationType.Dispatched);
        ArrayList entities = (ArrayList)noti.getParts();
        MimeEntity entity = (MimeEntity)entities.get(0);
        NotificationTest.assertEquals((String)"Your message was successfully processed.", (String)entity.getContent().toString());
        entity = (MimeEntity)entities.get(1);
        NotificationTest.assertTrue((boolean)entity.getContentType().startsWith("message/disposition-notification"));
        ByteArrayInputStream str = (ByteArrayInputStream)entity.getContent();
        byte[] bytes = new byte[str.available()];
        str.read(bytes);
        String content = new String(bytes);
        NotificationTest.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;dispatched"));
    }

    public void testCreateNotification_AssertInputStream() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        ByteArrayDataSource dataSource = new ByteArrayDataSource(noti.getInputStream(), noti.getAsMultipart().getContentType());
        MimeMultipart mm = new MimeMultipart((DataSource)dataSource);
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        NotificationTest.assertEquals((String)"Your message was successfully processed.", (String)part.getContent().toString());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayInputStream str = (ByteArrayInputStream)part.getContent();
        byte[] bytes = new byte[str.available()];
        str.read(bytes);
        String content = new String(bytes);
        NotificationTest.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    public void testSetExplanation_AssertExplanation() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        NotificationTest.assertEquals((String)"Your message was successfully processed.", (String)part.getContent().toString());
        noti.setExplanation("Testing this explantation");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(0);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        NotificationTest.assertEquals((String)"Testing this explantation", (String)noti.getExplanation());
        NotificationTest.assertEquals((String)noti.getExplanation(), (String)part.getContent().toString());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        part.writeTo((OutputStream)outStream);
        String content = new String(outStream.toByteArray());
        NotificationTest.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    public void testSetUserAgent_AssertUseragent() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Reporting-UA"));
        noti.setReportingAgent(new ReportingUserAgent("Junit Agent Name", "Junit Product Name"));
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Reporting-UA"));
        NotificationTest.assertEquals((String)"Junit Agent Name; Junit Product Name", (String)headers.getHeader("Reporting-UA", ","));
        NotificationTest.assertEquals((String)headers.getHeader("Reporting-UA", ","), (String)noti.getReportingAgent().toString());
    }

    public void testGateway_AssertGateway() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("MDN-Gateway"));
        noti.setGateway(new MdnGateway("Junit domain", "Junit type"));
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("MDN-Gateway"));
        NotificationTest.assertEquals((String)"Junit type; Junit domain", (String)headers.getHeader("MDN-Gateway", ","));
        NotificationTest.assertEquals((String)headers.getHeader("MDN-Gateway", ","), (String)noti.getGateway().toString());
    }

    public void testOriginalMessageId_AssertOriginalMessageId() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Original-Message-ID"));
        noti.setOriginalMessageId("Orig Msg Id");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Original-Message-ID"));
        NotificationTest.assertEquals((String)"Orig Msg Id", (String)headers.getHeader("Original-Message-ID", ","));
        NotificationTest.assertEquals((String)headers.getHeader("Original-Message-ID", ","), (String)noti.getOriginalMessageId());
    }

    public void testFinalRecip_AssertFinalRecip() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setFinalRecipient("Test Final Recip");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Final-Recipient"));
        NotificationTest.assertEquals((String)"rfc822; Test Final Recip", (String)headers.getHeader("Final-Recipient", ","));
        NotificationTest.assertEquals((String)headers.getHeader("Final-Recipient", ","), (String)("rfc822; " + noti.getFinalRecipeint()));
    }

    public void testError_AssertError() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Error"));
        noti.setError("Junit Error");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Error"));
        NotificationTest.assertEquals((String)"Junit Error", (String)headers.getHeader("Error", ","));
        NotificationTest.assertEquals((String)headers.getHeader("Error", ","), (String)noti.getError());
    }

    public void testParseFieldsFromMimeMessage() throws Exception {
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        InternetHeaders headers = Notification.getNotificationFieldsAsHeaders((MimeMessage)msg);
        NotificationTest.assertNotNull((Object)headers.getHeader("Disposition"));
        NotificationTest.assertEquals((String)"automatic-action/MDN-sent-automatically;processed", (String)headers.getHeader("Disposition", ","));
        NotificationTest.assertNotNull((Object)headers.getHeader("Reporting-UA"));
        NotificationTest.assertEquals((String)"starugh-stateline.com;NHIN Direct Security Agent", (String)headers.getHeader("Reporting-UA", ","));
        NotificationTest.assertNotNull((Object)headers.getHeader("Final-Recipient"));
        NotificationTest.assertEquals((String)"externUser1@starugh-stateline.com", (String)headers.getHeader("Final-Recipient", ","));
        NotificationTest.assertNotNull((Object)headers.getHeader("Original-Message-ID"));
        NotificationTest.assertEquals((String)"<9501051053.aa04167@IETF.CNR I.Reston.VA.US>", (String)headers.getHeader("Original-Message-ID", ","));
    }

    public void testParseFieldsFromMimeMessage_NonMDNMessage_AssertExecption() throws Exception {
        String testMessage = TestUtils.readResource("MessageWithAttachment.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        boolean exceptionOccured = false;
        try {
            Notification.getNotificationFieldsAsHeaders((MimeMessage)msg);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        NotificationTest.assertTrue((boolean)exceptionOccured);
    }

    public void testWarning_AssertWarning() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setWarning("junit warning");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Warning"));
        NotificationTest.assertEquals((String)"junit warning", (String)headers.getHeader("Warning", ","));
    }

    public void testFailure_AssertFailure() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setFailure("junit failure");
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("Failure"));
        NotificationTest.assertEquals((String)"junit failure", (String)headers.getHeader("Failure", ","));
    }

    public void testExtensions_AssertExtensions() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setExtensions(Arrays.asList("X-TEST1", "X-TEST2:value"));
        mm = noti.getAsMultipart();
        NotificationTest.assertNotNull((Object)mm);
        NotificationTest.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        NotificationTest.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        NotificationTest.assertNotNull((Object)headers.getHeader("X-TEST1"));
        NotificationTest.assertEquals((String)"", (String)headers.getHeader("X-TEST1", ","));
        NotificationTest.assertNotNull((Object)headers.getHeader("X-TEST2"));
        NotificationTest.assertEquals((String)"value", (String)headers.getHeader("X-TEST2", ","));
    }
}

