/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.utils;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAgentTest;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.testmodules.AgentTestModule;

public class TestUtils {
    private static final String certBasePath = "src/test/resources/certs/";
    private static final String crlBasePath = "src/test/resources/crl/";
    private static KeyStore keyStore;
    private static final String internalStorePassword = "h3||0 wor|d";
    private static final String pkPassword = "pKpa$$wd";

    public static X509CertificateEx getInternalCert(String alias) throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        return X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)((PrivateKey)keyStore.getKey("user1", pkPassword.toCharArray())));
    }

    public static X509Certificate getExternalCert(String alias) throws Exception {
        return (X509Certificate)keyStore.getCertificate(alias);
    }

    public static X509Certificate getInternalCACert(String alias) throws Exception {
        return (X509Certificate)keyStore.getCertificate(alias);
    }

    public static X509Certificate getExternalCACert(String alias) throws Exception {
        return (X509Certificate)keyStore.getCertificate(alias);
    }

    public static <T> TypeLiteral<Collection<T>> collectionOf(final Class<T> parameterType) {
        return TypeLiteral.get((Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{parameterType};
            }

            @Override
            public Type getRawType() {
                return Collection.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
    }

    public static DefaultNHINDAgent getStockAgent(Collection<String> domains) throws Exception {
        File fl = new File("testfile");
        int idx = fl.getAbsolutePath().lastIndexOf("testfile");
        String path = fl.getAbsolutePath().substring(0, idx);
        String internalKeystoreFile = path + "src/test/resources/keystores/internalKeystore";
        X509Certificate caCert = TestUtils.getExternalCert("cacert");
        X509Certificate externCaCert = TestUtils.getExternalCert("externCaCert");
        X509Certificate secureHealthEmailCACert = TestUtils.getExternalCert("secureHealthEmailCACert");
        X509Certificate msCACert = TestUtils.getExternalCert("msanchor");
        X509Certificate cernerDemos = TestUtils.getExternalCert("cernerDemosCaCert");
        ArrayList<X509Certificate> anchors = new ArrayList<X509Certificate>();
        anchors.add(caCert);
        anchors.add(externCaCert);
        anchors.add(secureHealthEmailCACert);
        anchors.add(msCACert);
        anchors.add(cernerDemos);
        AgentTestModule mod = new AgentTestModule(domains, anchors, internalKeystoreFile, internalStorePassword, pkPassword);
        Injector inj = Guice.createInjector((Module[])new Module[]{mod});
        return (DefaultNHINDAgent)inj.getInstance(DefaultNHINDAgent.class);
    }

    public static String readResource(String _rec) throws Exception {
        int BUF_SIZE = 2048;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(NHINDAgentTest.class.getResourceAsStream(_rec));
        ByteArrayOutputStream ouStream = new ByteArrayOutputStream();
        byte[] buf = new byte[BUF_SIZE];
        while ((count = imgStream.read(buf)) > -1) {
            ouStream.write(buf, 0, count);
        }
        try {
            imgStream.close();
        }
        catch (IOException ieo) {
            throw ieo;
        }
        catch (Exception e) {
            throw e;
        }
        return new String(ouStream.toByteArray());
    }

    public static X509Certificate loadCertificate(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        byte[] data = FileUtils.readFileToByteArray((File)fl);
        X509Certificate retVal = TestUtils.certFromData(data);
        return retVal;
    }

    public static CRL loadCRL(String certFileName) throws Exception {
        File fl = new File(crlBasePath + certFileName);
        FileInputStream str = FileUtils.openInputStream((File)fl);
        CRL retVal = CertificateFactory.getInstance("X.509").generateCRL(str);
        ((InputStream)str).close();
        return retVal;
    }

    public static X509Certificate certFromData(byte[] data) {
        X509Certificate retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    retVal = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)((PrivateKey)key)) : cert;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new NHINDException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return retVal;
    }

    static {
        try {
            int pos = Security.addProvider((Provider)new BouncyCastleProvider());
            System.out.println(pos);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            File fl = new File("testfile");
            int idx = fl.getAbsolutePath().lastIndexOf("testfile");
            String path = fl.getAbsolutePath().substring(0, idx);
            File internalKeystoreFile = new File(path + "src/test/resources/keystores/internalKeystore");
            FileInputStream inStream = new FileInputStream(internalKeystoreFile);
            keyStore.load(inStream, internalStorePassword.toCharArray());
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

