/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import junit.framework.TestCase;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsManagerUtils;
import org.nhindirect.stagent.options.OptionsParameter;

public class CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_noConfiguredJCENames_assertEmptyBCProvider() {
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"doesnt matter", (String)"doesnt matter"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_nullConfiguredJCENames_assertEmptyBCProvider() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", null));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"doesnt matter", (String)"doesnt matter"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_emptyConfiguredJCENames_assertEmptyBCProvider() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", ""));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"doesnt matter", (String)"doesnt matter"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_configuredJCENames_algAndTypeNotFound_assertEmptyProviderName() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", "BC"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"BC", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"doesnt matter", (String)"doesnt matter"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_configuredJCENames_unknownProvider_assertEmptyProviderName() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", "dummy"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"dummy", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"doesnt matter", (String)"doesnt matter"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_configuredJCENames_foundProvider_assertProviderName() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", "BC"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"BC", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"BC", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"CertPathValidator", (String)"PKIX"));
    }

    public void testGetJCEProviderNameForTypeAndAlgorithm_multipConfiguredJCENames_foundProvider_assertProviderName() {
        CryptoExtensions.registerJCEProviders();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER", "MOCK,BC"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER"));
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"MOCK,BC", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER").getParamValue());
        CryptoExtensions_getJCEProviderNameForTypeAndAlgorithmTest.assertEquals((String)"BC", (String)CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"CertPathValidator", (String)"PKIX"));
    }
}

