/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessIncoming_AsMimeMessage_Test
extends TestCase {
    public void testNullMessageParam_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected MimeMessage createMsg() throws Exception {
                this.theCreateMsg = null;
                return this.theCreateMsg;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateMsg);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testNonNullMessageParam_ProcessIncomingIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.assertEquals((int)1, (int)this.processIncomingCalls);
                Assert.assertEquals((Object)this.theProcessIncoming, (Object)processIncoming);
            }
        }.perform();
    }

    public void testInvalidMessage_ThrowsMimeException() throws Exception {
        new TestPlan(){

            @Override
            protected MimeMessage createMsg() throws Exception {
                this.theCreateMsg = new SecondaryMimeMessage();
                this.theCreateMsg.setRecipients(Message.RecipientType.TO, "some");
                this.theCreateMsg.setSender((Address)new InternetAddress());
                return this.theCreateMsg;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((boolean)(exception instanceof MimeException));
                MimeException mimeException = (MimeException)exception;
                Assert.assertEquals((Object)MimeError.InvalidMimeEntity, (Object)mimeException.getError());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected IncomingMessage theProcessIncoming;
        protected int processIncomingCalls = 0;
        protected MimeMessage theCreateMsg;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            IncomingMessage processIncoming = impl.processIncoming(this.createMsg());
            this.doAssertions(processIncoming);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                public IncomingMessage processIncoming(IncomingMessage message) {
                    ++TestPlan.this.processIncomingCalls;
                    return TestPlan.this.processIncoming_Internal(message);
                }
            };
        }

        protected IncomingMessage processIncoming_Internal(IncomingMessage message) {
            this.theProcessIncoming = message;
            return this.theProcessIncoming;
        }

        protected MimeMessage createMsg() throws Exception {
            this.theCreateMsg = new SecondaryMimeMessage();
            this.theCreateMsg.setText("");
            this.theCreateMsg.setRecipients(Message.RecipientType.TO, "some");
            this.theCreateMsg.setSender((Address)new InternetAddress());
            return this.theCreateMsg;
        }

        protected void doAssertions(IncomingMessage processIncoming) throws Exception {
        }
    }
}

