/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.Certificate;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.xbill.DNS.CERTRecord;

public class DNSCertificateStore_convertIPKIXRecordToCertTest
extends TestCase {
    protected String filePrefix;

    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
        File file = new File("./src/test/resources/certs/certCheckA.der");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
    }

    public void testConvertIPKIXRecordToCert_validCERTData_assertCertificate() throws Exception {
        File file = new File("./src/test/resources/certs/certCheckA.der");
        String url = this.filePrefix + file.getAbsolutePath();
        CERTRecord rec = (CERTRecord)Mockito.mock(CERTRecord.class);
        Mockito.when((Object)rec.getCert()).thenReturn((Object)url.getBytes());
        DNSCertificateStore store = new DNSCertificateStore();
        Certificate cert = store.convertIPKIXRecordToCert(rec);
        DNSCertificateStore_convertIPKIXRecordToCertTest.assertNotNull((Object)cert);
    }

    public void testConvertIPKIXRecordToCert_invalidCERTData_assertNoCertificate() throws Exception {
        File file = new File("./src/test/resources/log4j.properties");
        String url = this.filePrefix + file.getAbsolutePath();
        CERTRecord rec = (CERTRecord)Mockito.mock(CERTRecord.class);
        Mockito.when((Object)rec.getCert()).thenReturn((Object)url.getBytes());
        DNSCertificateStore store = new DNSCertificateStore();
        Certificate cert = store.convertIPKIXRecordToCert(rec);
        DNSCertificateStore_convertIPKIXRecordToCertTest.assertNull((Object)cert);
    }

    public void testConvertIPKIXRecordToCert_invalidURL_assertNoCertificate() throws Exception {
        CERTRecord rec = (CERTRecord)Mockito.mock(CERTRecord.class);
        Mockito.when((Object)rec.getCert()).thenReturn((Object)"http://localhost:9481/bogus".getBytes());
        DNSCertificateStore store = new DNSCertificateStore();
        Certificate cert = store.convertIPKIXRecordToCert(rec);
        DNSCertificateStore_convertIPKIXRecordToCertTest.assertNull((Object)cert);
    }
}

