/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.nhindirect.stagent.utils.TestUtils;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;

public class DNSCertificateStore_lookupDNSTest
extends TestCase {
    protected String filePrefix;

    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
        File file = new File("./src/test/resources/certs/certCheckA.der");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
    }

    protected Answer<Message> getPKIXAnswer(final byte[] certData) {
        Answer<Message> retVal = new Answer<Message>(){

            public Message answer(InvocationOnMock invocation) throws Throwable {
                Message request = (Message)invocation.getArguments()[0];
                Message response = new Message(request.getHeader().getID());
                response.getHeader().setFlag(0);
                if (request.getHeader().getFlag(7)) {
                    response.getHeader().setFlag(7);
                }
                response.addRecord(request.getQuestion(), 0);
                if (certData != null) {
                    CERTRecord rec = new CERTRecord(request.getQuestion().getName(), 1, 86400L, 1, 0, 5, certData);
                    response.addRecord((Record)rec, 1);
                } else {
                    response.getHeader().setRcode(3);
                }
                response.getHeader().setFlag(5);
                return response;
            }
        };
        return retVal;
    }

    protected Answer<Message> getIPKIXAnswer(final String url) {
        Answer<Message> retVal = new Answer<Message>(){

            public Message answer(InvocationOnMock invocation) throws Throwable {
                Message request = (Message)invocation.getArguments()[0];
                Message response = new Message(request.getHeader().getID());
                response.getHeader().setFlag(0);
                if (request.getHeader().getFlag(7)) {
                    response.getHeader().setFlag(7);
                }
                response.addRecord(request.getQuestion(), 0);
                CERTRecord rec = new CERTRecord(request.getQuestion().getName(), 1, 86400L, 253, 0, 5, url.getBytes());
                response.addRecord((Record)rec, 1);
                response.getHeader().setFlag(5);
                return response;
            }
        };
        return retVal;
    }

    public void testLookupDNS_certInRRRecord_assertCertificate() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("certCheckA.der");
        final ExtendedResolver resolver = (ExtendedResolver)Mockito.mock(ExtendedResolver.class);
        Mockito.when((Object)resolver.send((Message)Matchers.any())).thenAnswer(this.getPKIXAnswer(cert.getEncoded()));
        DNSCertificateStore store = new DNSCertificateStore(){

            protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
                return resolver;
            }
        };
        Collection certs = store.lookupDNS("somedomain.com");
        DNSCertificateStore_lookupDNSTest.assertNotNull((Object)certs);
        DNSCertificateStore_lookupDNSTest.assertEquals((int)1, (int)certs.size());
        DNSCertificateStore_lookupDNSTest.assertEquals((Object)cert, certs.iterator().next());
    }

    public void testLookupDNS_certNotInRRRecord_assertNoCertificate() throws Exception {
        final ExtendedResolver resolver = (ExtendedResolver)Mockito.mock(ExtendedResolver.class);
        Mockito.when((Object)resolver.send((Message)Matchers.any())).thenAnswer(this.getPKIXAnswer(null));
        DNSCertificateStore store = new DNSCertificateStore(){

            protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
                return resolver;
            }
        };
        Collection certs = store.lookupDNS("somedomain2.com");
        DNSCertificateStore_lookupDNSTest.assertNotNull((Object)certs);
        DNSCertificateStore_lookupDNSTest.assertTrue((boolean)certs.isEmpty());
    }

    public void testLookupDNS_certInIPKIXRecord_assertCertificate() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("gm2552.der");
        File certFile = new File("./src/test/resources/certs/gm2552.der");
        String url = this.filePrefix + certFile.getAbsolutePath();
        final ExtendedResolver resolver = (ExtendedResolver)Mockito.mock(ExtendedResolver.class);
        Mockito.when((Object)resolver.send((Message)Matchers.any())).thenAnswer(this.getIPKIXAnswer(url));
        DNSCertificateStore store = new DNSCertificateStore(){

            protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
                return resolver;
            }
        };
        Collection certs = store.lookupDNS("somedomain3.com");
        DNSCertificateStore_lookupDNSTest.assertNotNull((Object)certs);
        DNSCertificateStore_lookupDNSTest.assertEquals((int)1, (int)certs.size());
        DNSCertificateStore_lookupDNSTest.assertEquals((Object)cert, certs.iterator().next());
    }
}

