/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.policy.impl.UniversalPolicyResolver;

public class UniversalPolicyResolver_constructTest
extends TestCase {
    public void testConstruct_singleExpression_assertAttributes() {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        UniversalPolicyResolver_constructTest.assertNotNull((Object)resolver);
        UniversalPolicyResolver_constructTest.assertEquals((int)1, (int)resolver.expressions.size());
        UniversalPolicyResolver_constructTest.assertEquals((Object)expression, resolver.expressions.iterator().next());
    }

    public void testConstruct_multipleExpressions_assertAttributes() {
        PolicyExpression expression1 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        PolicyExpression expression2 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(Arrays.asList(expression1, expression2));
        UniversalPolicyResolver_constructTest.assertNotNull((Object)resolver);
        UniversalPolicyResolver_constructTest.assertEquals((int)2, (int)resolver.expressions.size());
        Iterator iter = resolver.expressions.iterator();
        UniversalPolicyResolver_constructTest.assertEquals((Object)expression1, iter.next());
        UniversalPolicyResolver_constructTest.assertEquals((Object)expression2, iter.next());
    }

    public void testConstruct_emptyExpression_assertException() {
        boolean exceptionOccured = false;
        try {
            new UniversalPolicyResolver(new ArrayList());
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        UniversalPolicyResolver_constructTest.assertTrue((boolean)exceptionOccured);
    }

    public void testConstruct_nullExpression_assertException() {
        boolean exceptionOccured = false;
        try {
            new UniversalPolicyResolver((PolicyExpression)null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        UniversalPolicyResolver_constructTest.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            new UniversalPolicyResolver((Collection)null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        UniversalPolicyResolver_constructTest.assertTrue((boolean)exceptionOccured);
    }
}

