/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.nhindirect.stagent.options.OptionsManagerUtils;

public class DNSCertificateStore_getServerQuerySettingsTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    public void testGetServerQuerySettingsTest_useDefaultSettings_assertSettings() {
        DNSCertificateStore service = new DNSCertificateStore();
        DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)2, (int)service.retries);
        DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)3, (int)service.timeout);
        DNSCertificateStore_getServerQuerySettingsTest.assertTrue((boolean)service.useTCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetServerQuerySettingsTest_useSettingsFromJVMParams_assertSettings() {
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "1");
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "5");
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "false");
        try {
            DNSCertificateStore service = new DNSCertificateStore();
            DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)1, (int)service.retries);
            DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)5, (int)service.timeout);
            DNSCertificateStore_getServerQuerySettingsTest.assertFalse((boolean)service.useTCP);
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetServerQuerySettingsTest_useSettingsFromPropertiesFile_assertSettings() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerRetries=5\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout=7\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP=false\r\n".getBytes());
            outStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        try {
            DNSCertificateStore service = new DNSCertificateStore();
            DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)5, (int)service.retries);
            DNSCertificateStore_getServerQuerySettingsTest.assertEquals((int)7, (int)service.timeout);
            DNSCertificateStore_getServerQuerySettingsTest.assertFalse((boolean)service.useTCP);
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "");
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            propFile.delete();
        }
    }
}

