/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import junit.framework.TestCase;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.TestUtils;

public class CryptographerTest
extends TestCase {
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
    }

    public void testEncryptAndDecryptMimeEntityAES128() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES128);
    }

    public void testEncryptAndDecryptMimeEntityAES256() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES256);
    }

    public void testEncryptAndDecryptMimeEntityRSA_3DES() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.RSA_3DES);
    }

    public void testEncryptAndDecryptMimeEntityAES192() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES192);
    }

    private void testEncryptAndDecryptMimeEntity(EncryptionAlgorithm encAlg) throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setEncryptionAlgorithm(encAlg);
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        MimeEntity decryEntity = cryptographer.decrypt(encEntity, certex);
        CryptographerTest.assertNotNull((Object)decryEntity);
        byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
    }

    public void testEncryptAndDecryptMimeEntity_sensitiveDataInPKCS11AES128() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptAndDecryptMimeEntity_sensitiveDataInPKCS11(EncryptionAlgorithm encAlg) throws Exception {
        OptionsManager.destroyInstance();
        System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderName", "SunPKCS11-SafeNeteTokenPro");
        System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderClassNames", "sun.security.pkcs11.SunPKCS11;./src/test/resources/pkcs11Config/pkcs11.cfg");
        CryptoExtensions.registerJCEProviders();
        try {
            X509Certificate cert = TestUtils.getExternalCert("user1");
            SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
            cryptographer.setEncryptionAlgorithm(encAlg);
            MimeEntity entity = new MimeEntity();
            entity.setText("Hello world.");
            entity.setHeader("Content-Type", "text/plain");
            entity.setHeader("Content-Transfer-Encoding", "7bit");
            MimeEntity encEntity = cryptographer.encrypt(entity, cert);
            CryptographerTest.assertNotNull((Object)encEntity);
            X509CertificateEx certex = TestUtils.getInternalCert("user1");
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            X509CertificateEx decryptCert = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                Certificate pkcs11Cert = ks.getCertificate(alias);
                if (pkcs11Cert == null || !(pkcs11Cert instanceof X509Certificate) || (key = ks.getKey(alias, null)) == null || !(key instanceof PrivateKey) || !CryptoExtensions.certSubjectContainsName((X509Certificate)((X509Certificate)pkcs11Cert), (String)"user1@cerner.com")) continue;
                decryptCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)pkcs11Cert), (PrivateKey)((PrivateKey)key));
                break;
            }
            MimeEntity decryEntity = cryptographer.decrypt(encEntity, decryptCert);
            CryptographerTest.assertNotNull((Object)decryEntity);
            byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
            byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
            CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderName", "Hello");
            System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderClassNames", "sun.security.pkcs11.SunPKCS11");
            OptionsManager.destroyInstance();
        }
    }

    public void testEncryptAndDecryptMultipartEntityAES128() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES128);
    }

    public void testEncryptAndDecryptMultipartEntityAES192() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES192);
    }

    public void testEncryptAndDecryptMultipartEntityAES256() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES256);
    }

    public void testEncryptAndDecryptMultipartEntityRSA_3DES() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.RSA_3DES);
    }

    private void testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm encAlgo) throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setEncryptionAlgorithm(encAlgo);
        MimeEntity entityText = new MimeEntity();
        entityText.setText("Hello world.");
        entityText.setHeader("Content-Type", "text/plain");
        entityText.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity entityXML = new MimeEntity();
        entityXML.setText("<Test></Test>");
        entityXML.setHeader("Content-Type", "text/xml");
        MimeMultipart mpEntity = new MimeMultipart();
        mpEntity.addBodyPart((BodyPart)entityText);
        mpEntity.addBodyPart((BodyPart)entityXML);
        MimeEntity encEntity = cryptographer.encrypt(mpEntity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        MimeEntity decryEntity = cryptographer.decrypt(encEntity, certex);
        CryptographerTest.assertNotNull((Object)decryEntity);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        mpEntity.writeTo((OutputStream)oStream);
        InternetHeaders hdrs = new InternetHeaders();
        hdrs.addHeader("Content-Type", mpEntity.getContentType());
        MimeEntity orgEntity = new MimeEntity(hdrs, oStream.toByteArray());
        byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)orgEntity);
        System.out.println("Original:\r\n" + new String(entityBytes));
        System.out.println("\r\n\r\n\r\nNew:\r\n" + new String(decryEntityBytes));
        CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
    }

    public void testSignMimeEntitySHA1() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA1);
    }

    public void testSignMimeEntitySHA256() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA256);
    }

    public void testSignMimeEntitySHA384() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA384);
    }

    public void testSignMimeEntitySHA512() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA512);
    }

    private void testSignMimeEntity(DigestAlgorithm digAlg) throws Exception {
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setDigestAlgorithm(digAlg);
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        byte[] signedEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)signedEnt.getContent());
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(signedEntityBytes, entityBytes));
        CryptographerTest.assertNotNull((Object)signedEnt.getSignature());
        X509Certificate cert = TestUtils.getExternalCert("user1");
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testEncryptAndSignMimeEntity() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testEncryptWithSingleCert_wrongDecryptCert_assertFailDecrypt() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("altnameonly");
        boolean exceptionOccured = false;
        try {
            cryptographer.decrypt(encEntity, certex);
        }
        catch (NHINDException e) {
            if (e.getError().equals(MimeError.Unexpected)) {
                // empty if block
            }
            exceptionOccured = true;
        }
        CryptographerTest.assertTrue((boolean)exceptionOccured);
    }

    public void testEncryptWithSingleCert_decryptWithMutlipeCerts_onlyOneCertCorrect_assertDecrypted() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex1 = TestUtils.getInternalCert("altnameonly");
        X509CertificateEx certex2 = TestUtils.getInternalCert("user1");
        MimeEntity decryEntity = cryptographer.decrypt(encEntity, Arrays.asList(certex1, certex2));
        CryptographerTest.assertNotNull((Object)decryEntity);
        byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
    }
}

