/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import org.nhindirect.stagent.mail.MailStandard;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.SendType;
import org.nhindirect.stagent.mail.notifications.TriggerType;

public class MDNStandard
extends MailStandard {
    public static final String Action_Manual = "manual-action";
    public static final String Action_Automatic = "automatic-action";
    public static final String Send_Manual = "MDN-sent-manually";
    public static final String Send_Automatic = "MDN-sent-automatically";
    public static final String Disposition_Displayed = "displayed";
    public static final String Disposition_Processed = "processed";
    public static final String Disposition_Dispatched = "dispatched";
    public static final String Disposition_Deleted = "deleted";
    public static final String Disposition_Denied = "denied";
    public static final String Disposition_Error = "error";
    public static final String Modifier_Error = "error";
    public static final String ReportType = "report-type";
    public static final String ReportTypeValueNotification = "disposition-notification";

    public static boolean hasMDNRequest(MimeEntity entity) {
        if (entity == null) {
            return false;
        }
        String[] headers = null;
        try {
            headers = entity.getHeader("Disposition-Notification-To");
        }
        catch (MessagingException e) {
            return false;
        }
        return headers != null && headers.length > 0;
    }

    public static boolean hasMDNRequest(MimeMessage msg) {
        if (msg == null) {
            return false;
        }
        String[] headers = null;
        try {
            headers = msg.getHeader("Disposition-Notification-To");
        }
        catch (MessagingException e) {
            return false;
        }
        return headers != null && headers.length > 0;
    }

    public static boolean isReport(MimeEntity entity) {
        if (entity == null) {
            return false;
        }
        ContentType contentType = MDNStandard.getContentType(entity);
        return contentType.match("multipart/report") && contentType.getParameter(ReportType) != null && contentType.getParameter(ReportType).equalsIgnoreCase(ReportTypeValueNotification);
    }

    public static boolean isReport(MimeMessage msg) {
        if (msg == null) {
            return false;
        }
        ContentType contentType = MDNStandard.getContentType(msg);
        return contentType.match("multipart/report") && contentType.getParameter(ReportType) != null && contentType.getParameter(ReportType).equalsIgnoreCase(ReportTypeValueNotification);
    }

    public static boolean isNotification(MimeEntity entity) {
        if (entity == null) {
            return false;
        }
        ContentType contentType = MDNStandard.getContentType(entity);
        return contentType.match("message/disposition-notification");
    }

    public static boolean isNotification(MimeMessage msg) {
        if (msg == null) {
            return false;
        }
        ContentType contentType = MDNStandard.getContentType(msg);
        return contentType.match("message/disposition-notification");
    }

    public static String toString(TriggerType mode) {
        switch (mode) {
            default: {
                throw new IllegalArgumentException();
            }
            case Automatic: {
                return Action_Automatic;
            }
            case UserInitiated: 
        }
        return Action_Manual;
    }

    public static String toString(SendType mode) {
        switch (mode) {
            default: {
                throw new IllegalArgumentException();
            }
            case Automatic: {
                return Send_Automatic;
            }
            case UserMediated: 
        }
        return Send_Manual;
    }

    public static String toString(NotificationType type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException();
            }
            case Processed: {
                return Disposition_Processed;
            }
            case Displayed: {
                return Disposition_Displayed;
            }
            case Deleted: {
                return Disposition_Deleted;
            }
            case Dispatched: {
                return Disposition_Dispatched;
            }
            case Denied: {
                return Disposition_Denied;
            }
            case Error: 
        }
        return "error";
    }

    private static ContentType getContentType(MimeMessage msg) {
        try {
            return new ContentType(msg.getContentType());
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    private static ContentType getContentType(MimeEntity entity) {
        try {
            return new ContentType(entity.getContentType());
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public static class Headers
    extends MailStandard.Headers {
        public static final String Disposition = "Disposition";
        public static final String DispositionNotificationTo = "Disposition-Notification-To";
        public static final String DispositionNotificationOptions = "Disposition-Notification-Options";
        public static final String ReportingAgent = "Reporting-UA";
        public static final String Gateway = "MDN-Gateway";
        public static final String OriginalMessageID = "Original-Message-ID";
        public static final String FinalRecipient = "Final-Recipient";
        public static final String OriginalRecipeint = "Original-Recipient";
        public static final String Failure = "Failure";
        public static final String Error = "Error";
        public static final String Warning = "Warning";
    }

    public static class MediaType
    extends MailStandard.MediaType {
        public static final String ReportMessage = "multipart/report";
        public static final String DispositionReport = "multipart/report; report-type=disposition-notification";
        public static final String DispositionNotification = "message/disposition-notification";
    }
}

