/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.nhindirect.stagent.trust.TrustChainValidator;

public class TrustTest {
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;

    public static void main(String[] args) {
        File certFileToTest;
        CryptoExtensions.registerJCEProviders();
        if (args.length == 0) {
            TrustTest.printUsage();
            System.exit(-1);
        }
        String configServiceURL = "";
        String bundleURL = "";
        String certFileName = "";
        String[] anchorFiles = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                TrustTest.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-cert")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing certificate file name");
                    System.exit(-1);
                }
                certFileName = args[++i];
                continue;
            }
            if (arg.equalsIgnoreCase("-bundleURL")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing bundle URL");
                    System.exit(-1);
                }
                bundleURL = args[++i];
                continue;
            }
            if (arg.equalsIgnoreCase("-configServiceURL")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing config service URL");
                    System.exit(-1);
                }
                configServiceURL = args[++i];
                continue;
            }
            if (arg.equals("-anchors")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing anchor file names");
                    System.exit(-1);
                }
                anchorFiles = args[++i].split(",");
                continue;
            }
            if (arg.equals("-help")) {
                TrustTest.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            TrustTest.printUsage();
            System.exit(-1);
        }
        if (certFileName == null || certFileName.isEmpty()) {
            System.err.println("You must provide the name of the certificate file to test.");
            TrustTest.printUsage();
        }
        if ((anchorFiles == null || anchorFiles.length == 0) && bundleURL.isEmpty() && configServiceURL.isEmpty()) {
            System.err.println("You must provide the name of the anchor files, a bundle URL, or config service URL.");
            TrustTest.printUsage();
        }
        if (!(certFileToTest = new File(certFileName)).exists()) {
            System.out.println("Certificate file " + certFileName + " does not exist.");
            System.exit(-1);
            return;
        }
        try {
            ArrayList<X509Certificate> anchors = new ArrayList<X509Certificate>();
            if (anchorFiles != null && anchorFiles.length > 0) {
                for (void var10_15 : anchorFiles) {
                    File anchorFile = new File((String)var10_15);
                    if (!anchorFile.exists()) {
                        System.out.println("Anchor file " + certFileName + " does not exist.");
                        System.exit(-1);
                        return;
                    }
                    anchors.add((X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(FileUtils.openInputStream((File)anchorFile)));
                }
            }
            if (!bundleURL.isEmpty()) {
                byte[] bundleBytes = TrustTest.downloadBundleToByteArray(bundleURL);
                if (bundleBytes == null) {
                    System.out.println("Could not get bundle at URL " + bundleURL);
                    System.exit(-1);
                }
                Collection<X509Certificate> bundleAnchors = TrustTest.convertRawBundleToAnchorCollection(bundleBytes);
                anchors.addAll(bundleAnchors);
            }
            X509Certificate certToTest = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(FileUtils.openInputStream((File)certFileToTest));
            TrustChainValidator chainValidator = new TrustChainValidator();
            List<CertificateResolver> intermediateResolvers = Arrays.asList(new DNSCertificateStore());
            chainValidator.setCertificateResolver(intermediateResolvers);
            boolean bl = chainValidator.isTrusted(certToTest, anchors);
            if (bl) {
                System.out.println("Certificate is trusted");
            } else {
                System.out.println("Certificate is NOT trusted");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] downloadBundleToByteArray(String url) {
        byte[] retVal;
        block6: {
            InputStream inputStream = null;
            retVal = null;
            ByteArrayOutputStream ouStream = new ByteArrayOutputStream();
            try {
                URL certURL = new URL(url);
                URLConnection connection = certURL.openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                inputStream = connection.getInputStream();
                int BUF_SIZE = 2048;
                int count = 0;
                byte[] buf = new byte[BUF_SIZE];
                while ((count = inputStream.read(buf)) > -1) {
                    ouStream.write(buf, 0, count);
                }
                retVal = ouStream.toByteArray();
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((OutputStream)ouStream);
            }
            IOUtils.closeQuietly((OutputStream)ouStream);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Collection<X509Certificate> convertRawBundleToAnchorCollection(byte[] rawBundle) {
        ByteArrayInputStream inStream;
        Collection<? extends Certificate> bundleCerts;
        block4: {
            bundleCerts = null;
            inStream = null;
            try {
                inStream = new ByteArrayInputStream(rawBundle);
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
                if (bundleCerts == null || bundleCerts.size() != 0) break block4;
                bundleCerts = null;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        return bundleCerts;
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java TrustTest (options)...\n\n");
        use.append("options:\n");
        use.append("-cert\t\tThe certificate file name that will be tested for trust.\n");
        use.append("\n");
        use.append("-anchors    Comma delimited list of anchors files used for trust.\n");
        System.err.println(use);
    }
}

