/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.provider;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustModel;

public class DefaultNHINDAgentProvider
implements Provider<NHINDAgent> {
    private Collection<String> domains;
    private Collection<Provider<CertificateResolver>> publicCerts;
    private Provider<CertificateResolver> privateCerts;
    private Provider<TrustAnchorResolver> trustResolver;

    public DefaultNHINDAgentProvider(Collection<String> domains, Provider<CertificateResolver> publicCerts, Provider<CertificateResolver> privateCerts, Provider<TrustAnchorResolver> trustResolver) {
        this(domains, Arrays.asList(publicCerts), privateCerts, trustResolver);
    }

    public DefaultNHINDAgentProvider(Collection<String> domains, Collection<Provider<CertificateResolver>> publicCerts, Provider<CertificateResolver> privateCerts, Provider<TrustAnchorResolver> trustResolver) {
        this.domains = domains;
        this.publicCerts = publicCerts;
        this.privateCerts = privateCerts;
        this.trustResolver = trustResolver;
    }

    public NHINDAgent get() {
        ArrayList<CertificateResolver> publicResolvers = new ArrayList<CertificateResolver>();
        for (Provider<CertificateResolver> provider : this.publicCerts) {
            publicResolvers.add((CertificateResolver)provider.get());
        }
        return new DefaultNHINDAgent(this.domains, (CertificateResolver)this.privateCerts.get(), publicResolvers, (TrustAnchorResolver)this.trustResolver.get(), TrustModel.Default, (Cryptographer)SMIMECryptographerImpl.Default);
    }
}

