/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDAgentEventListener;
import org.nhindirect.stagent.NHINDAgentEventListenerAdapter;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessOutgoing_Test
extends TestCase {
    public void testNullMessageParam_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected OutgoingMessage createMessage() throws Exception {
                this.theCreateMessage = null;
                return this.theCreateMessage;
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateMessage);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testAgentIsSetInMessage() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.assertNotNull((Object)processOutgoing.getAgent());
            }
        }.perform();
    }

    public void testMessageIsValidated() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.assertEquals((int)1, (int)this.validateCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToProcessMessageMethod() throws Exception {
        new MessageParamIsNotNull(){

            @Override
            protected void processMessage_Internal(OutgoingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.assertEquals((int)1, (int)this.processMessageCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToPreProcessOutgoingMethod() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){

            @Override
            protected void preProcessOutgoing_Internal(OutgoingMessage msg) throws NHINDException {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.assertEquals((int)1, (int)this.preProcessOutgoingCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToPostProcessOutgoingMethod() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){

            @Override
            protected void postProcessOutgoing_Internal(OutgoingMessage msg) throws NHINDException {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.assertEquals((int)1, (int)this.postProcessOutgoingCalls);
            }
        }.perform();
    }

    public void testPostProcessOutgoingMethodThrowsException_ErrorOutgoingIsCalled() throws Exception {
        new NHINDAgentEventListenerIsNotNull(){
            protected NHINDException nhindException;

            @Override
            protected void postProcessOutgoing_Internal(OutgoingMessage msg) throws NHINDException {
                this.nhindException = new NHINDException();
                throw this.nhindException;
            }

            @Override
            protected void errorOutgoing_Internal(OutgoingMessage msg, Exception e) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)msg);
                Assert.assertEquals((Object)((Object)this.nhindException), (Object)e);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertEquals((int)1, (int)this.errorOutgoingCalls);
            }
        }.perform();
    }

    class NHINDAgentEventListenerIsNotNull
    extends MessageParamIsNotNull {
        protected int errorOutgoingCalls;
        protected int postProcessOutgoingCalls;
        protected int preProcessOutgoingCalls;

        NHINDAgentEventListenerIsNotNull() {
            this.errorOutgoingCalls = 0;
            this.postProcessOutgoingCalls = 0;
            this.preProcessOutgoingCalls = 0;
        }

        @Override
        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            DefaultNHINDAgent nhindAgent = new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void processMessage(OutgoingMessage message) {
                    ++NHINDAgentEventListenerIsNotNull.this.processMessageCalls;
                    NHINDAgentEventListenerIsNotNull.this.processMessage_Internal(message);
                }
            };
            nhindAgent.setEventListener((NHINDAgentEventListener)new NHINDAgentEventListenerAdapter(){

                @Override
                public void errorOutgoing(OutgoingMessage msg, Exception e) {
                    ++NHINDAgentEventListenerIsNotNull.this.errorOutgoingCalls;
                    NHINDAgentEventListenerIsNotNull.this.errorOutgoing_Internal(msg, e);
                }

                @Override
                public void postProcessOutgoing(OutgoingMessage msg) throws NHINDException {
                    ++NHINDAgentEventListenerIsNotNull.this.postProcessOutgoingCalls;
                    NHINDAgentEventListenerIsNotNull.this.postProcessOutgoing_Internal(msg);
                }

                @Override
                public void preProcessOutgoing(OutgoingMessage msg) throws NHINDException {
                    ++NHINDAgentEventListenerIsNotNull.this.preProcessOutgoingCalls;
                    NHINDAgentEventListenerIsNotNull.this.preProcessOutgoing_Internal(msg);
                }
            });
            return nhindAgent;
        }

        protected void errorOutgoing_Internal(OutgoingMessage msg, Exception e) {
        }

        protected void postProcessOutgoing_Internal(OutgoingMessage msg) throws NHINDException {
        }

        protected void preProcessOutgoing_Internal(OutgoingMessage msg) throws NHINDException {
        }
    }

    class MessageParamIsNotNull
    extends TestPlan {
        protected int validateCalls;

        MessageParamIsNotNull() {
            this.validateCalls = 0;
        }

        @Override
        protected OutgoingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new OutgoingMessage(msg, recipients, sender){

                protected void validate() {
                    ++MessageParamIsNotNull.this.validateCalls;
                    MessageParamIsNotNull.this.validate_Internal();
                }
            };
            return this.theCreateMessage;
        }

        protected void validate_Internal() {
        }
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int processMessageCalls = 0;
        protected OutgoingMessage theCreateMessage;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createNHINDAgent();
            OutgoingMessage processOutgoing = impl.processOutgoing(this.createMessage());
            this.doAssertions(processOutgoing);
        }

        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void processMessage(OutgoingMessage message) {
                    ++TestPlan.this.processMessageCalls;
                    TestPlan.this.processMessage_Internal(message);
                }
            };
        }

        protected void processMessage_Internal(OutgoingMessage message) {
        }

        protected OutgoingMessage createMessage() throws Exception {
            this.theCreateMessage = new OutgoingMessage("");
            return this.theCreateMessage;
        }

        protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
        }
    }
}

