/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.SignerInformation;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.MessageSignature;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.cert.Thumbprint;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class DefaultMessageSignatureImpl
implements MessageSignature {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultMessageSignatureImpl.class);
    private boolean signatureValid;
    private SignerInformation signer;
    private boolean useOrgCertificate;
    private boolean thumbprintVerified;
    private X509Certificate signerCert;
    private boolean m_logDigest = false;

    public DefaultMessageSignatureImpl(SignerInformation signer, boolean useOrgCert, X509Certificate cert) {
        if (signer == null) {
            throw new IllegalArgumentException();
        }
        this.signer = signer;
        this.signatureValid = false;
        this.useOrgCertificate = useOrgCert;
        this.thumbprintVerified = false;
        this.signerCert = cert;
        OptionsParameter param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_LOG_DIGESTS");
        this.m_logDigest = OptionsParameter.getParamValueAsBoolean(param, false);
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public SignerInformation getSigner() {
        return this.signer;
    }

    public boolean isUseOrgCertificate() {
        return this.useOrgCertificate;
    }

    public boolean isThumbprintVerified() {
        return this.thumbprintVerified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSignature() {
        try {
            this.signatureValid = this.signer.verify(this.signerCert, CryptoExtensions.getJCEProviderName());
        }
        catch (Exception e) {
            this.signatureValid = false;
        }
        finally {
            this.logDigests(this.signer);
        }
        return this.signatureValid;
    }

    private void logDigests(SignerInformation sigInfo) {
        if (this.m_logDigest && sigInfo != null) {
            try {
                Attribute digAttr = sigInfo.getSignedAttributes().get(CMSAttributes.messageDigest);
                DERObject hashObj = digAttr.getAttrValues().getObjectAt(0).getDERObject();
                byte[] signedDigest = ((ASN1OctetString)hashObj).getOctets();
                String signedDigestHex = Hex.encodeHexString((byte[])signedDigest);
                LOGGER.info((Object)("Signed Message Digest: " + signedDigestHex));
                byte[] digest = sigInfo.getContentDigest();
                String digestHex = Hex.encodeHexString((byte[])digest);
                LOGGER.info((Object)("Computed Message Digest: " + digestHex));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean checkThumbprint(NHINDAddress messageSender) {
        this.thumbprintVerified = false;
        Thumbprint sigThumbprint = Thumbprint.toThumbprint(this.getSignerCert());
        if (messageSender.hasCertificates()) {
            for (X509Certificate checkCert : messageSender.getCertificates()) {
                if (!sigThumbprint.equals(Thumbprint.toThumbprint(checkCert))) continue;
                this.thumbprintVerified = true;
                break;
            }
        }
        return this.thumbprintVerified;
    }
}

