/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.cert.CertificateResolver;

public class TrustAnchorCertificateStore
implements CertificateResolver {
    private Map<String, Collection<X509Certificate>> certs;

    public TrustAnchorCertificateStore(Map<String, Collection<X509Certificate>> certs) {
        this.setCertificates(certs);
    }

    public void setCertificates(Map<String, Collection<X509Certificate>> certs) {
        if (certs == null) {
            throw new IllegalArgumentException();
        }
        this.certs = new HashMap<String, Collection<X509Certificate>>();
        for (Map.Entry<String, Collection<X509Certificate>> entry : certs.entrySet()) {
            this.certs.put(entry.getKey().toUpperCase(Locale.getDefault()), entry.getValue());
        }
    }

    @Override
    public Collection<X509Certificate> getCertificates(InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        String domain = NHINDAddress.getHost(address);
        Collection<X509Certificate> retCerts = this.certs.get(domain = domain.toUpperCase(Locale.getDefault()));
        if (retCerts == null) {
            retCerts = Collections.emptyList();
        }
        return retCerts;
    }
}

